package com.xforceplus.ultraman.app.biassetmanagementservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.biassetmanagementservice.entity.StructureChangeRepairetask;
import com.xforceplus.ultraman.app.biassetmanagementservice.service.IStructureChangeRepairetaskService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-07-08
 */
@RestController
public class StructureChangeRepairetaskController {

  @Autowired
  private IStructureChangeRepairetaskService structureChangeRepairetaskServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param structureChangeRepairetask ${table.comment}
   * @return
   */
  @GetMapping("/structurechangerepairetasks" )
  public XfR getStructureChangeRepairetasks(XfPage page, StructureChangeRepairetask structureChangeRepairetask) {
    return XfR.ok(structureChangeRepairetaskServiceImpl.page(page, Wrappers.query(structureChangeRepairetask)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/structurechangerepairetasks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(structureChangeRepairetaskServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param structureChangeRepairetask ${table.comment}
   * @return XfR
   */
  @PostMapping("/structurechangerepairetasks")
  public XfR save(@RequestBody StructureChangeRepairetask structureChangeRepairetask) {
     return XfR.ok(structureChangeRepairetaskServiceImpl.save(structureChangeRepairetask));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param structureChangeRepairetask ${table.comment}
   * @return XfR
   */
  @PutMapping("/structurechangerepairetasks/{id}")
  public XfR putUpdate(@RequestBody StructureChangeRepairetask structureChangeRepairetask,@PathVariable Long id) {
      structureChangeRepairetask.setId(id);
      return XfR.ok(structureChangeRepairetaskServiceImpl.updateById(structureChangeRepairetask));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param structureChangeRepairetask ${table.comment}
   * @return XfR
   */
  @PatchMapping("/structurechangerepairetasks/{id}")
  public XfR patchUpdate(@RequestBody StructureChangeRepairetask structureChangeRepairetask,@PathVariable Long id) {
      StructureChangeRepairetask upstructureChangeRepairetask = structureChangeRepairetaskServiceImpl.getById(id);
      if(upstructureChangeRepairetask != null){
        upstructureChangeRepairetask = ObjectCopyUtils.copyProperties(structureChangeRepairetask,upstructureChangeRepairetask,true);
      }
      return XfR.ok(structureChangeRepairetaskServiceImpl.updateById(upstructureChangeRepairetask));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/structurechangerepairetasks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(structureChangeRepairetaskServiceImpl.removeById(id));
  }

  @PostMapping("/structurechangerepairetasks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "structure_change_repairetask");
     params.put("request", condition);

     return XfR.ok(structureChangeRepairetaskServiceImpl.querys(params));
  }

}
