package com.xforceplus.ultraman.app.biassetmanagementservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.biassetmanagementservice.entity.SyncDbDataToRedshiftTasklog;
import com.xforceplus.ultraman.app.biassetmanagementservice.service.ISyncDbDataToRedshiftTasklogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-07-08
 */
@RestController
public class SyncDbDataToRedshiftTasklogController {

  @Autowired
  private ISyncDbDataToRedshiftTasklogService syncDbDataToRedshiftTasklogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param syncDbDataToRedshiftTasklog ${table.comment}
   * @return
   */
  @GetMapping("/syncdbdatatoredshifttasklogs" )
  public XfR getSyncDbDataToRedshiftTasklogs(XfPage page, SyncDbDataToRedshiftTasklog syncDbDataToRedshiftTasklog) {
    return XfR.ok(syncDbDataToRedshiftTasklogServiceImpl.page(page, Wrappers.query(syncDbDataToRedshiftTasklog)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/syncdbdatatoredshifttasklogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(syncDbDataToRedshiftTasklogServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param syncDbDataToRedshiftTasklog ${table.comment}
   * @return XfR
   */
  @PostMapping("/syncdbdatatoredshifttasklogs")
  public XfR save(@RequestBody SyncDbDataToRedshiftTasklog syncDbDataToRedshiftTasklog) {
     return XfR.ok(syncDbDataToRedshiftTasklogServiceImpl.save(syncDbDataToRedshiftTasklog));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param syncDbDataToRedshiftTasklog ${table.comment}
   * @return XfR
   */
  @PutMapping("/syncdbdatatoredshifttasklogs/{id}")
  public XfR putUpdate(@RequestBody SyncDbDataToRedshiftTasklog syncDbDataToRedshiftTasklog,@PathVariable Long id) {
      syncDbDataToRedshiftTasklog.setId(id);
      return XfR.ok(syncDbDataToRedshiftTasklogServiceImpl.updateById(syncDbDataToRedshiftTasklog));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param syncDbDataToRedshiftTasklog ${table.comment}
   * @return XfR
   */
  @PatchMapping("/syncdbdatatoredshifttasklogs/{id}")
  public XfR patchUpdate(@RequestBody SyncDbDataToRedshiftTasklog syncDbDataToRedshiftTasklog,@PathVariable Long id) {
      SyncDbDataToRedshiftTasklog upsyncDbDataToRedshiftTasklog = syncDbDataToRedshiftTasklogServiceImpl.getById(id);
      if(upsyncDbDataToRedshiftTasklog != null){
        upsyncDbDataToRedshiftTasklog = ObjectCopyUtils.copyProperties(syncDbDataToRedshiftTasklog,upsyncDbDataToRedshiftTasklog,true);
      }
      return XfR.ok(syncDbDataToRedshiftTasklogServiceImpl.updateById(upsyncDbDataToRedshiftTasklog));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/syncdbdatatoredshifttasklogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(syncDbDataToRedshiftTasklogServiceImpl.removeById(id));
  }

  @PostMapping("/syncdbdatatoredshifttasklogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sync_db_data_to_redshift_tasklog");
     params.put("request", condition);

     return XfR.ok(syncDbDataToRedshiftTasklogServiceImpl.querys(params));
  }

}
