package com.xforceplus.ultraman.app.biassetmanagementservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.biassetmanagementservice.entity.SyncTaskCheckRecord;
import com.xforceplus.ultraman.app.biassetmanagementservice.service.ISyncTaskCheckRecordService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-07-08
 */
@RestController
public class SyncTaskCheckRecordController {

  @Autowired
  private ISyncTaskCheckRecordService syncTaskCheckRecordServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param syncTaskCheckRecord ${table.comment}
   * @return
   */
  @GetMapping("/synctaskcheckrecords" )
  public XfR getSyncTaskCheckRecords(XfPage page, SyncTaskCheckRecord syncTaskCheckRecord) {
    return XfR.ok(syncTaskCheckRecordServiceImpl.page(page, Wrappers.query(syncTaskCheckRecord)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/synctaskcheckrecords/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(syncTaskCheckRecordServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param syncTaskCheckRecord ${table.comment}
   * @return XfR
   */
  @PostMapping("/synctaskcheckrecords")
  public XfR save(@RequestBody SyncTaskCheckRecord syncTaskCheckRecord) {
     return XfR.ok(syncTaskCheckRecordServiceImpl.save(syncTaskCheckRecord));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param syncTaskCheckRecord ${table.comment}
   * @return XfR
   */
  @PutMapping("/synctaskcheckrecords/{id}")
  public XfR putUpdate(@RequestBody SyncTaskCheckRecord syncTaskCheckRecord,@PathVariable Long id) {
      syncTaskCheckRecord.setId(id);
      return XfR.ok(syncTaskCheckRecordServiceImpl.updateById(syncTaskCheckRecord));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param syncTaskCheckRecord ${table.comment}
   * @return XfR
   */
  @PatchMapping("/synctaskcheckrecords/{id}")
  public XfR patchUpdate(@RequestBody SyncTaskCheckRecord syncTaskCheckRecord,@PathVariable Long id) {
      SyncTaskCheckRecord upsyncTaskCheckRecord = syncTaskCheckRecordServiceImpl.getById(id);
      if(upsyncTaskCheckRecord != null){
        upsyncTaskCheckRecord = ObjectCopyUtils.copyProperties(syncTaskCheckRecord,upsyncTaskCheckRecord,true);
      }
      return XfR.ok(syncTaskCheckRecordServiceImpl.updateById(upsyncTaskCheckRecord));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/synctaskcheckrecords/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(syncTaskCheckRecordServiceImpl.removeById(id));
  }

  @PostMapping("/synctaskcheckrecords/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sync_task_check_record");
     params.put("request", condition);

     return XfR.ok(syncTaskCheckRecordServiceImpl.querys(params));
  }

}
