package com.xforceplus.ultraman.app.biassetmanagementservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.biassetmanagementservice.entity.SyncTaskMappingVersions;
import com.xforceplus.ultraman.app.biassetmanagementservice.service.ISyncTaskMappingVersionsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-07-08
 */
@RestController
public class SyncTaskMappingVersionsController {

  @Autowired
  private ISyncTaskMappingVersionsService syncTaskMappingVersionsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param syncTaskMappingVersions ${table.comment}
   * @return
   */
  @GetMapping("/synctaskmappingversionss" )
  public XfR getSyncTaskMappingVersionss(XfPage page, SyncTaskMappingVersions syncTaskMappingVersions) {
    return XfR.ok(syncTaskMappingVersionsServiceImpl.page(page, Wrappers.query(syncTaskMappingVersions)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/synctaskmappingversionss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(syncTaskMappingVersionsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param syncTaskMappingVersions ${table.comment}
   * @return XfR
   */
  @PostMapping("/synctaskmappingversionss")
  public XfR save(@RequestBody SyncTaskMappingVersions syncTaskMappingVersions) {
     return XfR.ok(syncTaskMappingVersionsServiceImpl.save(syncTaskMappingVersions));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param syncTaskMappingVersions ${table.comment}
   * @return XfR
   */
  @PutMapping("/synctaskmappingversionss/{id}")
  public XfR putUpdate(@RequestBody SyncTaskMappingVersions syncTaskMappingVersions,@PathVariable Long id) {
      syncTaskMappingVersions.setId(id);
      return XfR.ok(syncTaskMappingVersionsServiceImpl.updateById(syncTaskMappingVersions));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param syncTaskMappingVersions ${table.comment}
   * @return XfR
   */
  @PatchMapping("/synctaskmappingversionss/{id}")
  public XfR patchUpdate(@RequestBody SyncTaskMappingVersions syncTaskMappingVersions,@PathVariable Long id) {
      SyncTaskMappingVersions upsyncTaskMappingVersions = syncTaskMappingVersionsServiceImpl.getById(id);
      if(upsyncTaskMappingVersions != null){
        upsyncTaskMappingVersions = ObjectCopyUtils.copyProperties(syncTaskMappingVersions,upsyncTaskMappingVersions,true);
      }
      return XfR.ok(syncTaskMappingVersionsServiceImpl.updateById(upsyncTaskMappingVersions));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/synctaskmappingversionss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(syncTaskMappingVersionsServiceImpl.removeById(id));
  }

  @PostMapping("/synctaskmappingversionss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sync_task_mapping_versions");
     params.put("request", condition);

     return XfR.ok(syncTaskMappingVersionsServiceImpl.querys(params));
  }

}
