package com.xforceplus.ultraman.app.biassetmanagementservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.biassetmanagementservice.entity.TableAudit;
import com.xforceplus.ultraman.app.biassetmanagementservice.service.ITableAuditService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-07-08
 */
@RestController
public class TableAuditController {

  @Autowired
  private ITableAuditService tableAuditServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param tableAudit ${table.comment}
   * @return
   */
  @GetMapping("/tableaudits" )
  public XfR getTableAudits(XfPage page, TableAudit tableAudit) {
    return XfR.ok(tableAuditServiceImpl.page(page, Wrappers.query(tableAudit)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/tableaudits/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(tableAuditServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param tableAudit ${table.comment}
   * @return XfR
   */
  @PostMapping("/tableaudits")
  public XfR save(@RequestBody TableAudit tableAudit) {
     return XfR.ok(tableAuditServiceImpl.save(tableAudit));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param tableAudit ${table.comment}
   * @return XfR
   */
  @PutMapping("/tableaudits/{id}")
  public XfR putUpdate(@RequestBody TableAudit tableAudit,@PathVariable Long id) {
      tableAudit.setId(id);
      return XfR.ok(tableAuditServiceImpl.updateById(tableAudit));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param tableAudit ${table.comment}
   * @return XfR
   */
  @PatchMapping("/tableaudits/{id}")
  public XfR patchUpdate(@RequestBody TableAudit tableAudit,@PathVariable Long id) {
      TableAudit uptableAudit = tableAuditServiceImpl.getById(id);
      if(uptableAudit != null){
        uptableAudit = ObjectCopyUtils.copyProperties(tableAudit,uptableAudit,true);
      }
      return XfR.ok(tableAuditServiceImpl.updateById(uptableAudit));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tableaudits/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(tableAuditServiceImpl.removeById(id));
  }

  @PostMapping("/tableaudits/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "table_audit");
     params.put("request", condition);

     return XfR.ok(tableAuditServiceImpl.querys(params));
  }

}
