package com.xforceplus.ultraman.app.biassetmanagementservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.biassetmanagementservice.entity.WarnNoticeInfo;
import com.xforceplus.ultraman.app.biassetmanagementservice.service.IWarnNoticeInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-07-08
 */
@RestController
public class WarnNoticeInfoController {

  @Autowired
  private IWarnNoticeInfoService warnNoticeInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param warnNoticeInfo ${table.comment}
   * @return
   */
  @GetMapping("/warnnoticeinfos" )
  public XfR getWarnNoticeInfos(XfPage page, WarnNoticeInfo warnNoticeInfo) {
    return XfR.ok(warnNoticeInfoServiceImpl.page(page, Wrappers.query(warnNoticeInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/warnnoticeinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(warnNoticeInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param warnNoticeInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/warnnoticeinfos")
  public XfR save(@RequestBody WarnNoticeInfo warnNoticeInfo) {
     return XfR.ok(warnNoticeInfoServiceImpl.save(warnNoticeInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param warnNoticeInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/warnnoticeinfos/{id}")
  public XfR putUpdate(@RequestBody WarnNoticeInfo warnNoticeInfo,@PathVariable Long id) {
      warnNoticeInfo.setId(id);
      return XfR.ok(warnNoticeInfoServiceImpl.updateById(warnNoticeInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param warnNoticeInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/warnnoticeinfos/{id}")
  public XfR patchUpdate(@RequestBody WarnNoticeInfo warnNoticeInfo,@PathVariable Long id) {
      WarnNoticeInfo upwarnNoticeInfo = warnNoticeInfoServiceImpl.getById(id);
      if(upwarnNoticeInfo != null){
        upwarnNoticeInfo = ObjectCopyUtils.copyProperties(warnNoticeInfo,upwarnNoticeInfo,true);
      }
      return XfR.ok(warnNoticeInfoServiceImpl.updateById(upwarnNoticeInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/warnnoticeinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(warnNoticeInfoServiceImpl.removeById(id));
  }

  @PostMapping("/warnnoticeinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "warn_notice_info");
     params.put("request", condition);

     return XfR.ok(warnNoticeInfoServiceImpl.querys(params));
  }

}
