package com.xforceplus.ultraman.app.biassetmanagementservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.biassetmanagementservice.entity.Asset;
import com.xforceplus.ultraman.app.biassetmanagementservice.service.IAssetService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-05-15
 */
@RestController
public class AssetController {

  @Autowired
  private IAssetService assetServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param asset ${table.comment}
   * @return
   */
  @GetMapping("/assets" )
  public XfR getAssets(XfPage page, Asset asset) {
    return XfR.ok(assetServiceImpl.page(page, Wrappers.query(asset)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/assets/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(assetServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param asset ${table.comment}
   * @return XfR
   */
  @PostMapping("/assets")
  public XfR save(@RequestBody Asset asset) {
     return XfR.ok(assetServiceImpl.save(asset));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param asset ${table.comment}
   * @return XfR
   */
  @PutMapping("/assets/{id}")
  public XfR putUpdate(@RequestBody Asset asset,@PathVariable Long id) {
      asset.setId(id);
      return XfR.ok(assetServiceImpl.updateById(asset));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param asset ${table.comment}
   * @return XfR
   */
  @PatchMapping("/assets/{id}")
  public XfR patchUpdate(@RequestBody Asset asset,@PathVariable Long id) {
      Asset upasset = assetServiceImpl.getById(id);
      if(upasset != null){
        upasset = ObjectCopyUtils.copyProperties(asset,upasset,true);
      }
      return XfR.ok(assetServiceImpl.updateById(upasset));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/assets/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(assetServiceImpl.removeById(id));
  }

  @PostMapping("/assets/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "asset");
     params.put("request", condition);

     return XfR.ok(assetServiceImpl.querys(params));
  }

}
