package com.xforceplus.ultraman.app.biassetmanagementservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.biassetmanagementservice.entity.AssetRel;
import com.xforceplus.ultraman.app.biassetmanagementservice.service.IAssetRelService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-05-15
 */
@RestController
public class AssetRelController {

  @Autowired
  private IAssetRelService assetRelServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param assetRel ${table.comment}
   * @return
   */
  @GetMapping("/assetrels" )
  public XfR getAssetRels(XfPage page, AssetRel assetRel) {
    return XfR.ok(assetRelServiceImpl.page(page, Wrappers.query(assetRel)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/assetrels/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(assetRelServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param assetRel ${table.comment}
   * @return XfR
   */
  @PostMapping("/assetrels")
  public XfR save(@RequestBody AssetRel assetRel) {
     return XfR.ok(assetRelServiceImpl.save(assetRel));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param assetRel ${table.comment}
   * @return XfR
   */
  @PutMapping("/assetrels/{id}")
  public XfR putUpdate(@RequestBody AssetRel assetRel,@PathVariable Long id) {
      assetRel.setId(id);
      return XfR.ok(assetRelServiceImpl.updateById(assetRel));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param assetRel ${table.comment}
   * @return XfR
   */
  @PatchMapping("/assetrels/{id}")
  public XfR patchUpdate(@RequestBody AssetRel assetRel,@PathVariable Long id) {
      AssetRel upassetRel = assetRelServiceImpl.getById(id);
      if(upassetRel != null){
        upassetRel = ObjectCopyUtils.copyProperties(assetRel,upassetRel,true);
      }
      return XfR.ok(assetRelServiceImpl.updateById(upassetRel));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/assetrels/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(assetRelServiceImpl.removeById(id));
  }

  @PostMapping("/assetrels/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "asset_rel");
     params.put("request", condition);

     return XfR.ok(assetRelServiceImpl.querys(params));
  }

}
