package com.xforceplus.ultraman.app.biassetmanagementservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.biassetmanagementservice.entity.Procedure;
import com.xforceplus.ultraman.app.biassetmanagementservice.service.IProcedureService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-05-15
 */
@RestController
public class ProcedureController {

  @Autowired
  private IProcedureService procedureServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param procedure ${table.comment}
   * @return
   */
  @GetMapping("/procedures" )
  public XfR getProcedures(XfPage page, Procedure procedure) {
    return XfR.ok(procedureServiceImpl.page(page, Wrappers.query(procedure)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/procedures/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(procedureServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param procedure ${table.comment}
   * @return XfR
   */
  @PostMapping("/procedures")
  public XfR save(@RequestBody Procedure procedure) {
     return XfR.ok(procedureServiceImpl.save(procedure));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param procedure ${table.comment}
   * @return XfR
   */
  @PutMapping("/procedures/{id}")
  public XfR putUpdate(@RequestBody Procedure procedure,@PathVariable Long id) {
      procedure.setId(id);
      return XfR.ok(procedureServiceImpl.updateById(procedure));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param procedure ${table.comment}
   * @return XfR
   */
  @PatchMapping("/procedures/{id}")
  public XfR patchUpdate(@RequestBody Procedure procedure,@PathVariable Long id) {
      Procedure upprocedure = procedureServiceImpl.getById(id);
      if(upprocedure != null){
        upprocedure = ObjectCopyUtils.copyProperties(procedure,upprocedure,true);
      }
      return XfR.ok(procedureServiceImpl.updateById(upprocedure));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/procedures/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(procedureServiceImpl.removeById(id));
  }

  @PostMapping("/procedures/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "procedure");
     params.put("request", condition);

     return XfR.ok(procedureServiceImpl.querys(params));
  }

}
