package com.xforceplus.ultraman.app.biassetmanagementservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.biassetmanagementservice.entity.StatisticsLog;
import com.xforceplus.ultraman.app.biassetmanagementservice.service.IStatisticsLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-05-15
 */
@RestController
public class StatisticsLogController {

  @Autowired
  private IStatisticsLogService statisticsLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param statisticsLog ${table.comment}
   * @return
   */
  @GetMapping("/statisticslogs" )
  public XfR getStatisticsLogs(XfPage page, StatisticsLog statisticsLog) {
    return XfR.ok(statisticsLogServiceImpl.page(page, Wrappers.query(statisticsLog)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/statisticslogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(statisticsLogServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param statisticsLog ${table.comment}
   * @return XfR
   */
  @PostMapping("/statisticslogs")
  public XfR save(@RequestBody StatisticsLog statisticsLog) {
     return XfR.ok(statisticsLogServiceImpl.save(statisticsLog));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param statisticsLog ${table.comment}
   * @return XfR
   */
  @PutMapping("/statisticslogs/{id}")
  public XfR putUpdate(@RequestBody StatisticsLog statisticsLog,@PathVariable Long id) {
      statisticsLog.setId(id);
      return XfR.ok(statisticsLogServiceImpl.updateById(statisticsLog));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param statisticsLog ${table.comment}
   * @return XfR
   */
  @PatchMapping("/statisticslogs/{id}")
  public XfR patchUpdate(@RequestBody StatisticsLog statisticsLog,@PathVariable Long id) {
      StatisticsLog upstatisticsLog = statisticsLogServiceImpl.getById(id);
      if(upstatisticsLog != null){
        upstatisticsLog = ObjectCopyUtils.copyProperties(statisticsLog,upstatisticsLog,true);
      }
      return XfR.ok(statisticsLogServiceImpl.updateById(upstatisticsLog));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/statisticslogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(statisticsLogServiceImpl.removeById(id));
  }

  @PostMapping("/statisticslogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "statistics_log");
     params.put("request", condition);

     return XfR.ok(statisticsLogServiceImpl.querys(params));
  }

}
