package com.xforceplus.ultraman.app.biassetmanagementservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.biassetmanagementservice.entity.SyncDbDataToRedshiftTask;
import com.xforceplus.ultraman.app.biassetmanagementservice.service.ISyncDbDataToRedshiftTaskService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-05-15
 */
@RestController
public class SyncDbDataToRedshiftTaskController {

  @Autowired
  private ISyncDbDataToRedshiftTaskService syncDbDataToRedshiftTaskServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param syncDbDataToRedshiftTask ${table.comment}
   * @return
   */
  @GetMapping("/syncdbdatatoredshifttasks" )
  public XfR getSyncDbDataToRedshiftTasks(XfPage page, SyncDbDataToRedshiftTask syncDbDataToRedshiftTask) {
    return XfR.ok(syncDbDataToRedshiftTaskServiceImpl.page(page, Wrappers.query(syncDbDataToRedshiftTask)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/syncdbdatatoredshifttasks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(syncDbDataToRedshiftTaskServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param syncDbDataToRedshiftTask ${table.comment}
   * @return XfR
   */
  @PostMapping("/syncdbdatatoredshifttasks")
  public XfR save(@RequestBody SyncDbDataToRedshiftTask syncDbDataToRedshiftTask) {
     return XfR.ok(syncDbDataToRedshiftTaskServiceImpl.save(syncDbDataToRedshiftTask));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param syncDbDataToRedshiftTask ${table.comment}
   * @return XfR
   */
  @PutMapping("/syncdbdatatoredshifttasks/{id}")
  public XfR putUpdate(@RequestBody SyncDbDataToRedshiftTask syncDbDataToRedshiftTask,@PathVariable Long id) {
      syncDbDataToRedshiftTask.setId(id);
      return XfR.ok(syncDbDataToRedshiftTaskServiceImpl.updateById(syncDbDataToRedshiftTask));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param syncDbDataToRedshiftTask ${table.comment}
   * @return XfR
   */
  @PatchMapping("/syncdbdatatoredshifttasks/{id}")
  public XfR patchUpdate(@RequestBody SyncDbDataToRedshiftTask syncDbDataToRedshiftTask,@PathVariable Long id) {
      SyncDbDataToRedshiftTask upsyncDbDataToRedshiftTask = syncDbDataToRedshiftTaskServiceImpl.getById(id);
      if(upsyncDbDataToRedshiftTask != null){
        upsyncDbDataToRedshiftTask = ObjectCopyUtils.copyProperties(syncDbDataToRedshiftTask,upsyncDbDataToRedshiftTask,true);
      }
      return XfR.ok(syncDbDataToRedshiftTaskServiceImpl.updateById(upsyncDbDataToRedshiftTask));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/syncdbdatatoredshifttasks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(syncDbDataToRedshiftTaskServiceImpl.removeById(id));
  }

  @PostMapping("/syncdbdatatoredshifttasks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sync_db_data_to_redshift_task");
     params.put("request", condition);

     return XfR.ok(syncDbDataToRedshiftTaskServiceImpl.querys(params));
  }

}
