package com.xforceplus.ultraman.app.biassetmanagementservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.biassetmanagementservice.entity.SyncRedshiftTaskJobLock;
import com.xforceplus.ultraman.app.biassetmanagementservice.service.ISyncRedshiftTaskJobLockService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-05-15
 */
@RestController
public class SyncRedshiftTaskJobLockController {

  @Autowired
  private ISyncRedshiftTaskJobLockService syncRedshiftTaskJobLockServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param syncRedshiftTaskJobLock ${table.comment}
   * @return
   */
  @GetMapping("/syncredshifttaskjoblocks" )
  public XfR getSyncRedshiftTaskJobLocks(XfPage page, SyncRedshiftTaskJobLock syncRedshiftTaskJobLock) {
    return XfR.ok(syncRedshiftTaskJobLockServiceImpl.page(page, Wrappers.query(syncRedshiftTaskJobLock)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/syncredshifttaskjoblocks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(syncRedshiftTaskJobLockServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param syncRedshiftTaskJobLock ${table.comment}
   * @return XfR
   */
  @PostMapping("/syncredshifttaskjoblocks")
  public XfR save(@RequestBody SyncRedshiftTaskJobLock syncRedshiftTaskJobLock) {
     return XfR.ok(syncRedshiftTaskJobLockServiceImpl.save(syncRedshiftTaskJobLock));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param syncRedshiftTaskJobLock ${table.comment}
   * @return XfR
   */
  @PutMapping("/syncredshifttaskjoblocks/{id}")
  public XfR putUpdate(@RequestBody SyncRedshiftTaskJobLock syncRedshiftTaskJobLock,@PathVariable Long id) {
      syncRedshiftTaskJobLock.setId(id);
      return XfR.ok(syncRedshiftTaskJobLockServiceImpl.updateById(syncRedshiftTaskJobLock));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param syncRedshiftTaskJobLock ${table.comment}
   * @return XfR
   */
  @PatchMapping("/syncredshifttaskjoblocks/{id}")
  public XfR patchUpdate(@RequestBody SyncRedshiftTaskJobLock syncRedshiftTaskJobLock,@PathVariable Long id) {
      SyncRedshiftTaskJobLock upsyncRedshiftTaskJobLock = syncRedshiftTaskJobLockServiceImpl.getById(id);
      if(upsyncRedshiftTaskJobLock != null){
        upsyncRedshiftTaskJobLock = ObjectCopyUtils.copyProperties(syncRedshiftTaskJobLock,upsyncRedshiftTaskJobLock,true);
      }
      return XfR.ok(syncRedshiftTaskJobLockServiceImpl.updateById(upsyncRedshiftTaskJobLock));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/syncredshifttaskjoblocks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(syncRedshiftTaskJobLockServiceImpl.removeById(id));
  }

  @PostMapping("/syncredshifttaskjoblocks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sync_redshift_task_job_lock");
     params.put("request", condition);

     return XfR.ok(syncRedshiftTaskJobLockServiceImpl.querys(params));
  }

}
