package com.xforceplus.ultraman.app.biassetmanagementservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.biassetmanagementservice.entity.SyncTaskExeNodeInfo;
import com.xforceplus.ultraman.app.biassetmanagementservice.service.ISyncTaskExeNodeInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-05-15
 */
@RestController
public class SyncTaskExeNodeInfoController {

  @Autowired
  private ISyncTaskExeNodeInfoService syncTaskExeNodeInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param syncTaskExeNodeInfo ${table.comment}
   * @return
   */
  @GetMapping("/synctaskexenodeinfos" )
  public XfR getSyncTaskExeNodeInfos(XfPage page, SyncTaskExeNodeInfo syncTaskExeNodeInfo) {
    return XfR.ok(syncTaskExeNodeInfoServiceImpl.page(page, Wrappers.query(syncTaskExeNodeInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/synctaskexenodeinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(syncTaskExeNodeInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param syncTaskExeNodeInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/synctaskexenodeinfos")
  public XfR save(@RequestBody SyncTaskExeNodeInfo syncTaskExeNodeInfo) {
     return XfR.ok(syncTaskExeNodeInfoServiceImpl.save(syncTaskExeNodeInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param syncTaskExeNodeInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/synctaskexenodeinfos/{id}")
  public XfR putUpdate(@RequestBody SyncTaskExeNodeInfo syncTaskExeNodeInfo,@PathVariable Long id) {
      syncTaskExeNodeInfo.setId(id);
      return XfR.ok(syncTaskExeNodeInfoServiceImpl.updateById(syncTaskExeNodeInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param syncTaskExeNodeInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/synctaskexenodeinfos/{id}")
  public XfR patchUpdate(@RequestBody SyncTaskExeNodeInfo syncTaskExeNodeInfo,@PathVariable Long id) {
      SyncTaskExeNodeInfo upsyncTaskExeNodeInfo = syncTaskExeNodeInfoServiceImpl.getById(id);
      if(upsyncTaskExeNodeInfo != null){
        upsyncTaskExeNodeInfo = ObjectCopyUtils.copyProperties(syncTaskExeNodeInfo,upsyncTaskExeNodeInfo,true);
      }
      return XfR.ok(syncTaskExeNodeInfoServiceImpl.updateById(upsyncTaskExeNodeInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/synctaskexenodeinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(syncTaskExeNodeInfoServiceImpl.removeById(id));
  }

  @PostMapping("/synctaskexenodeinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sync_task_exe_node_info");
     params.put("request", condition);

     return XfR.ok(syncTaskExeNodeInfoServiceImpl.querys(params));
  }

}
