package com.xforceplus.ultraman.app.biassetmanagementservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.biassetmanagementservice.entity.Table;
import com.xforceplus.ultraman.app.biassetmanagementservice.service.ITableService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-05-15
 */
@RestController
public class TableController {

  @Autowired
  private ITableService tableServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param table ${table.comment}
   * @return
   */
  @GetMapping("/tables" )
  public XfR getTables(XfPage page, Table table) {
    return XfR.ok(tableServiceImpl.page(page, Wrappers.query(table)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/tables/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(tableServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param table ${table.comment}
   * @return XfR
   */
  @PostMapping("/tables")
  public XfR save(@RequestBody Table table) {
     return XfR.ok(tableServiceImpl.save(table));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param table ${table.comment}
   * @return XfR
   */
  @PutMapping("/tables/{id}")
  public XfR putUpdate(@RequestBody Table table,@PathVariable Long id) {
      table.setId(id);
      return XfR.ok(tableServiceImpl.updateById(table));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param table ${table.comment}
   * @return XfR
   */
  @PatchMapping("/tables/{id}")
  public XfR patchUpdate(@RequestBody Table table,@PathVariable Long id) {
      Table uptable = tableServiceImpl.getById(id);
      if(uptable != null){
        uptable = ObjectCopyUtils.copyProperties(table,uptable,true);
      }
      return XfR.ok(tableServiceImpl.updateById(uptable));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tables/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(tableServiceImpl.removeById(id));
  }

  @PostMapping("/tables/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "table");
     params.put("request", condition);

     return XfR.ok(tableServiceImpl.querys(params));
  }

}
