package com.xforceplus.ultraman.app.biassetmanagementservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.biassetmanagementservice.entity.WarnNoticeDetail;
import com.xforceplus.ultraman.app.biassetmanagementservice.service.IWarnNoticeDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-05-15
 */
@RestController
public class WarnNoticeDetailController {

  @Autowired
  private IWarnNoticeDetailService warnNoticeDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param warnNoticeDetail ${table.comment}
   * @return
   */
  @GetMapping("/warnnoticedetails" )
  public XfR getWarnNoticeDetails(XfPage page, WarnNoticeDetail warnNoticeDetail) {
    return XfR.ok(warnNoticeDetailServiceImpl.page(page, Wrappers.query(warnNoticeDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/warnnoticedetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(warnNoticeDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param warnNoticeDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/warnnoticedetails")
  public XfR save(@RequestBody WarnNoticeDetail warnNoticeDetail) {
     return XfR.ok(warnNoticeDetailServiceImpl.save(warnNoticeDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param warnNoticeDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/warnnoticedetails/{id}")
  public XfR putUpdate(@RequestBody WarnNoticeDetail warnNoticeDetail,@PathVariable Long id) {
      warnNoticeDetail.setId(id);
      return XfR.ok(warnNoticeDetailServiceImpl.updateById(warnNoticeDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param warnNoticeDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/warnnoticedetails/{id}")
  public XfR patchUpdate(@RequestBody WarnNoticeDetail warnNoticeDetail,@PathVariable Long id) {
      WarnNoticeDetail upwarnNoticeDetail = warnNoticeDetailServiceImpl.getById(id);
      if(upwarnNoticeDetail != null){
        upwarnNoticeDetail = ObjectCopyUtils.copyProperties(warnNoticeDetail,upwarnNoticeDetail,true);
      }
      return XfR.ok(warnNoticeDetailServiceImpl.updateById(upwarnNoticeDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/warnnoticedetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(warnNoticeDetailServiceImpl.removeById(id));
  }

  @PostMapping("/warnnoticedetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "warn_notice_detail");
     params.put("request", condition);

     return XfR.ok(warnNoticeDetailServiceImpl.querys(params));
  }

}
