package com.xforceplus.ultraman.app.bitaskprocess.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.bitaskprocess.entity.MothReportConfirm;
import com.xforceplus.ultraman.app.bitaskprocess.service.IMothReportConfirmService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-02-04
 */
@RestController
public class MothReportConfirmController {

  @Autowired
  private IMothReportConfirmService mothReportConfirmServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param mothReportConfirm ${table.comment}
   * @return
   */
  @GetMapping("/mothreportconfirms" )
  public XfR getMothReportConfirms(XfPage page, MothReportConfirm mothReportConfirm) {
    return XfR.ok(mothReportConfirmServiceImpl.page(page, Wrappers.query(mothReportConfirm)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/mothreportconfirms/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(mothReportConfirmServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param mothReportConfirm ${table.comment}
   * @return XfR
   */
  @PostMapping("/mothreportconfirms")
  public XfR save(@RequestBody MothReportConfirm mothReportConfirm) {
     return XfR.ok(mothReportConfirmServiceImpl.save(mothReportConfirm));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param mothReportConfirm ${table.comment}
   * @return XfR
   */
  @PutMapping("/mothreportconfirms/{id}")
  public XfR putUpdate(@RequestBody MothReportConfirm mothReportConfirm,@PathVariable Long id) {
      mothReportConfirm.setId(id);
      return XfR.ok(mothReportConfirmServiceImpl.updateById(mothReportConfirm));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param mothReportConfirm ${table.comment}
   * @return XfR
   */
  @PatchMapping("/mothreportconfirms/{id}")
  public XfR patchUpdate(@RequestBody MothReportConfirm mothReportConfirm,@PathVariable Long id) {
      MothReportConfirm upmothReportConfirm = mothReportConfirmServiceImpl.getById(id);
      if(upmothReportConfirm != null){
        upmothReportConfirm = ObjectCopyUtils.copyProperties(mothReportConfirm,upmothReportConfirm,true);
      }
      return XfR.ok(mothReportConfirmServiceImpl.updateById(upmothReportConfirm));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/mothreportconfirms/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(mothReportConfirmServiceImpl.removeById(id));
  }

  @PostMapping("/mothreportconfirms/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "moth_report_confirm");
     params.put("request", condition);

     return XfR.ok(mothReportConfirmServiceImpl.querys(params));
  }

}
