package com.xforceplus.ultraman.app.casservice.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2023-12-18
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.casservice.entity.SalesArchivesChangedHistory;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "cas-service")
public interface SalesArchivesChangedHistoryFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/salesArchivesChangedHistory/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param salesArchivesChangedHistory ${table.comment}
   * @return R
   */
  @PostMapping("/salesArchivesChangedHistory/add")
  public R save(@RequestBody SalesArchivesChangedHistory salesArchivesChangedHistory);

  /**
   * 修改${table.comment}
   * @param salesArchivesChangedHistory ${table.comment}
   * @return R
   */
  @PostMapping("/salesArchivesChangedHistory/update")
  public R updateById(@RequestBody SalesArchivesChangedHistory salesArchivesChangedHistory);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/salesArchivesChangedHistory/del/{id}" )
  public R removeById(@PathVariable Long id);

}