package com.xforceplus.ultraman.app.casservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * change_table_type
 * </p>
 *
 * @author ultraman
 * @since 2024-08-07
 */
public enum ChangeTableType {

    _1("1", "门店映射"),
    _2("2", "门店标准化"),
    _3("3", "门店基础数据");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ChangeTableType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChangeTableType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
