package com.xforceplus.ultraman.app.casservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * retailer_supplier_mapping_status
 * </p>
 *
 * @author ultraman
 * @since 2024-08-07
 */
public enum RetailerSupplierMappingStatus {

    _1("1", "有效"),
    _0("0", "无效");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    RetailerSupplierMappingStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RetailerSupplierMappingStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
