package com.xforceplus.ultraman.app.casservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * strore_info
 * </p>
 *
 * @author ultraman
 * @since 2024-08-07
 */
public enum StroreInfo {

    RTMART("rtmart", "大润发"),
    CRV("crv", "华润万家"),
    SUGUO("suguo", "华润苏果"),
    CRV_O_L_E("crvOLE", "华润OLE"),
    WALMART("walmart", "沃尔玛"),
    SAM("sam", "山姆"),
    METRO("metro", "麦德龙"),
    RENRENLE("renrenle", "人人乐"),
    BJHL("bjhl", "北京华联"),
    WUMART("wumart", "物美"),
    YONGHUI("yonghui", "永辉"),
    DENNIS("dennis", "丹尼斯"),
    JIAJIAYUE("jiajiayue", "家家悦"),
    BBG("bbg", "步步高"),
    HEMA("hema", "盒马"),
    LIKELONG("likelong", "利客隆"),
    LOTUS("lotus", "卜蜂莲花"),
    CENTURYMART("centurymart", "世纪联华"),
    OUYA("ouya", "欧亚"),
    WANGFUJING("wangfujing", "王府井"),
    WUSHANG("wushang", "武商"),
    YINZUO("yinzuo", "银座"),
    HEJIAFU("hejiafu", "合家福"),
    ZBDC("zbdc", "中百仓储"),
    CDC("cdc", "昌大昌"),
    BAIJIAHUA("baijiahua", "百佳华"),
    RAINBOW("rainbow", "天虹"),
    HONGQI("hongqi", "红旗"),
    LIKELAI("likelai", "利客来"),
    ZHONGSHANG("zhongshang", "中商平价");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    StroreInfo(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static StroreInfo fromCode(String code){
        switch(code) {
            case "rtmart":
                return RTMART;
            case "crv":
                return CRV;
            case "suguo":
                return SUGUO;
            case "crvOLE":
                return CRV_O_L_E;
            case "walmart":
                return WALMART;
            case "sam":
                return SAM;
            case "metro":
                return METRO;
            case "renrenle":
                return RENRENLE;
            case "bjhl":
                return BJHL;
            case "wumart":
                return WUMART;
            case "yonghui":
                return YONGHUI;
            case "dennis":
                return DENNIS;
            case "jiajiayue":
                return JIAJIAYUE;
            case "bbg":
                return BBG;
            case "hema":
                return HEMA;
            case "likelong":
                return LIKELONG;
            case "lotus":
                return LOTUS;
            case "centurymart":
                return CENTURYMART;
            case "ouya":
                return OUYA;
            case "wangfujing":
                return WANGFUJING;
            case "wushang":
                return WUSHANG;
            case "yinzuo":
                return YINZUO;
            case "hejiafu":
                return HEJIAFU;
            case "zbdc":
                return ZBDC;
            case "cdc":
                return CDC;
            case "baijiahua":
                return BAIJIAHUA;
            case "rainbow":
                return RAINBOW;
            case "hongqi":
                return HONGQI;
            case "likelai":
                return LIKELAI;
            case "zhongshang":
                return ZHONGSHANG;
            default:
                return null;
        }
    }
}
