package com.xforceplus.ultraman.app.casservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * retailer_tenant_code
 * </p>
 *
 * @author ultraman
 * @since 2024-08-09
 */
public enum RetailerTenantCode {

    WILMAR("wilmar", "益海嘉里"),
    TQLS("tqls", "铁骑力士"),
    QZDREAM("qzdream", "千织护理"),
    T_WPEPSICO("TWpepsico", "台湾百事"),
    BUDWEISER_A_P_A_C("BudweiserAPAC", "百威"),
    UNILEVER_D_T_C("UnileverDTC", "联合利华");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    RetailerTenantCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RetailerTenantCode fromCode(String code){
        switch(code) {
            case "wilmar":
                return WILMAR;
            case "tqls":
                return TQLS;
            case "qzdream":
                return QZDREAM;
            case "TWpepsico":
                return T_WPEPSICO;
            case "BudweiserAPAC":
                return BUDWEISER_A_P_A_C;
            case "UnileverDTC":
                return UNILEVER_D_T_C;
            default:
                return null;
        }
    }
}
