package com.xforceplus.ultraman.app.casservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * rule_type
 * </p>
 *
 * @author ultraman
 * @since 2025-05-07
 */
public enum RuleType {

    _1("1", "零售商品牌商业务映射业务规则"),
    _3("3", "销商档案数据业务规则"),
    _2("2", "门店基础数据业务规则");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    RuleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RuleType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "3":
                return _3;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
