package com.xforceplus.ultraman.app.casservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * audit_status
 * </p>
 *
 * @author ultraman
 * @since 2024-01-30
 */
public enum AuditStatus {

    _0("0", "未审核"),
    _1("1", "审核通过"),
    _2("2", "审核未通过");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AuditStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AuditStatus fromCode(String code) {
        return Stream.of(AuditStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
