package com.xforceplus.ultraman.app.casservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * strore_info
 * </p>
 *
 * @author ultraman
 * @since 2024-01-30
 */
public enum StroreInfo {

    RTMART("rtmart", "大润发"),
    CRV("crv", "华润万家"),
    SUGUO("suguo", "华润苏果"),
    CRV_O_L_E("crvOLE", "华润OLE");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    StroreInfo(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static StroreInfo fromCode(String code) {
        return Stream.of(StroreInfo.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
