package com.xforceplus.ultraman.app.casservice.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * retailer_supplier_mapping
 * </p>
 *
 * @author ultraman
 * @since 2024-01-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class RetailerSupplierMapping implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 零售商编码
   */
  private String retailerCode;
  /**
   * 零售商名称
   */
  private String retailerName;
  /**
   * 门店编码
   */
  private String storeCode;
  /**
   * 门店名称
   */
  private String storeName;
  /**
   * 供应商编码
   */
  private String supplierCode;
  /**
   * 供应商名称
   */
  private String supplierName;
  /**
   * 物流模式
   */
  private String shippedBy;
  /**
   * 大仓编码
   */
  private String warehouseCode;
  /**
   * 状态
   */
  private String status;
  /**
   * 审核状态
   */
  private String auditStatus;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 大仓名称
   */
  private String warehouseName;
  /**
   * 场景码
   */
  private String sceneCode;
  /**
   * 零售商id
   */
  private String ext1;
  /**
   * 销售组织代码
   */
  private String salesOrgnizationCode;
  /**
   * 销售组织名称
   */
  private String salesOrgnizationName;

  /**
   * 对一关联关系 关联对象 salesArchives
   */
  private Long oneoneForSalesArchivesId;
  /**
   * 对一关联关系 关联对象 purchaseOrgs
   */
  private Long shopRelId;
  /**
   * 对一关联关系 关联对象 orgInfo
   */
  private Long orgRelId;
  /**
   * 对一关联关系 关联对象 orgSoldToParty
   */
  private Long orgSoldToPartyRelId;
  /**
   * 对一关联关系 关联对象 orgSoldShipToParty
   */
  private Long orgSoldShipToPartyRelId;

  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("retailerCode", retailerCode);
      map.put("retailerName", retailerName);
      map.put("storeCode", storeCode);
      map.put("storeName", storeName);
      map.put("supplierCode", supplierCode);
      map.put("supplierName", supplierName);
      map.put("shippedBy", shippedBy);
      map.put("warehouseCode", warehouseCode);
      map.put("status", status);
      map.put("auditStatus", auditStatus);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("warehouseName", warehouseName);
      map.put("sceneCode", sceneCode);
      map.put("ext1", ext1);
      map.put("salesOrgnizationCode", salesOrgnizationCode);
      map.put("salesOrgnizationName", salesOrgnizationName);

      map.put("oneoneForSalesArchives.id", oneoneForSalesArchivesId);
      map.put("shopRel.id", shopRelId);
      map.put("orgRel.id", orgRelId);
      map.put("orgSoldToPartyRel.id", orgSoldToPartyRelId);
      map.put("orgSoldShipToPartyRel.id", orgSoldShipToPartyRelId);
      return map;
  }

  public static RetailerSupplierMapping fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    RetailerSupplierMapping entity = new RetailerSupplierMapping();

    if(map.containsKey("retailerCode")) {
      Object obj = map.get("retailerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRetailerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retailerName")) {
      Object obj = map.get("retailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeCode")) {
      Object obj = map.get("storeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeName")) {
      Object obj = map.get("storeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierCode")) {
      Object obj = map.get("supplierCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shippedBy")) {
      Object obj = map.get("shippedBy");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShippedBy((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warehouseCode")) {
      Object obj = map.get("warehouseCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWarehouseCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auditStatus")) {
      Object obj = map.get("auditStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuditStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warehouseName")) {
      Object obj = map.get("warehouseName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWarehouseName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sceneCode")) {
      Object obj = map.get("sceneCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSceneCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrgnizationCode")) {
      Object obj = map.get("salesOrgnizationCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesOrgnizationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrgnizationName")) {
      Object obj = map.get("salesOrgnizationName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesOrgnizationName((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("oneoneForSalesArchives.id")) {
       Object obj = map.get("oneoneForSalesArchives.id");
       if(obj instanceof Long) {
         entity.setOneoneForSalesArchivesId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setOneoneForSalesArchivesId(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("shopRel.id")) {
       Object obj = map.get("shopRel.id");
       if(obj instanceof Long) {
         entity.setShopRelId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setShopRelId(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("orgRel.id")) {
       Object obj = map.get("orgRel.id");
       if(obj instanceof Long) {
         entity.setOrgRelId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setOrgRelId(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("orgSoldToPartyRel.id")) {
       Object obj = map.get("orgSoldToPartyRel.id");
       if(obj instanceof Long) {
         entity.setOrgSoldToPartyRelId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setOrgSoldToPartyRelId(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("orgSoldShipToPartyRel.id")) {
       Object obj = map.get("orgSoldShipToPartyRel.id");
       if(obj instanceof Long) {
         entity.setOrgSoldShipToPartyRelId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setOrgSoldShipToPartyRelId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("retailerCode")) {
      Object obj = map.get("retailerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRetailerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retailerName")) {
      Object obj = map.get("retailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeCode")) {
      Object obj = map.get("storeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeName")) {
      Object obj = map.get("storeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierCode")) {
      Object obj = map.get("supplierCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSupplierCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSupplierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shippedBy")) {
      Object obj = map.get("shippedBy");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setShippedBy((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warehouseCode")) {
      Object obj = map.get("warehouseCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setWarehouseCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auditStatus")) {
      Object obj = map.get("auditStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAuditStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warehouseName")) {
      Object obj = map.get("warehouseName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setWarehouseName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sceneCode")) {
      Object obj = map.get("sceneCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSceneCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrgnizationCode")) {
      Object obj = map.get("salesOrgnizationCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesOrgnizationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrgnizationName")) {
      Object obj = map.get("salesOrgnizationName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesOrgnizationName((String)obj);
        }
      } else{
      }
    }
  if(map.containsKey("oneoneForSalesArchives.id")) {
    Object obj = map.get("oneoneForSalesArchives.id");
    if(obj instanceof Long) {
        this.setOneoneForSalesArchivesId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setOneoneForSalesArchivesId(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("shopRel.id")) {
    Object obj = map.get("shopRel.id");
    if(obj instanceof Long) {
        this.setShopRelId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setShopRelId(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("orgRel.id")) {
    Object obj = map.get("orgRel.id");
    if(obj instanceof Long) {
        this.setOrgRelId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setOrgRelId(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("orgSoldToPartyRel.id")) {
    Object obj = map.get("orgSoldToPartyRel.id");
    if(obj instanceof Long) {
        this.setOrgSoldToPartyRelId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setOrgSoldToPartyRelId(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("orgSoldShipToPartyRel.id")) {
    Object obj = map.get("orgSoldShipToPartyRel.id");
    if(obj instanceof Long) {
        this.setOrgSoldShipToPartyRelId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setOrgSoldShipToPartyRelId(Long.parseLong((String)obj));
    }
  }
  }
}
