package com.xforceplus.ultraman.app.casservice.metadata.validator;

import com.xforceplus.ultraman.app.casservice.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.casservice.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-01-30
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(RetailerSupplierMappingStatus.class)) {
            isValid = null != RetailerSupplierMappingStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RetailerSupplierMappingStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AuditStatus.class)) {
            isValid = null != AuditStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuditStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SalesArchivesType.class)) {
            isValid = null != SalesArchivesType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SalesArchivesType.class.getSimpleName());
            }
        }
        if(clazz.equals(SceneCode.class)) {
            isValid = null != SceneCode.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SceneCode.class.getSimpleName());
            }
        }
        if(clazz.equals(RuleType.class)) {
            isValid = null != RuleType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RuleType.class.getSimpleName());
            }
        }
        if(clazz.equals(ConfigItemValueType.class)) {
            isValid = null != ConfigItemValueType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ConfigItemValueType.class.getSimpleName());
            }
        }
        if(clazz.equals(ActiveStatus.class)) {
            isValid = null != ActiveStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ActiveStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ConversionStatus.class)) {
            isValid = null != ConversionStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ConversionStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(StroreInfo.class)) {
            isValid = null != StroreInfo.fromCode(value);
            if(!isValid) {
                unValidMsg(context, StroreInfo.class.getSimpleName());
            }
        }
        if(clazz.equals(SalesArchivesStatus.class)) {
            isValid = null != SalesArchivesStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SalesArchivesStatus.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
