package com.xforceplus.ultraman.app.casservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * change_table_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-08
 */
public enum ChangeTableType {

    _1("1", "门店映射"),
    _2("2", "门店标准化"),
    _3("3", "门店基础数据");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ChangeTableType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChangeTableType fromCode(String code) {
        return Stream.of(ChangeTableType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
