package com.xforceplus.ultraman.app.casservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * change_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-08
 */
public enum ChangeType {

    _1("1", "新增"),
    _2("2", "修改"),
    _3("3", "删除"),
    _4("4", "有效设置"),
    _5("5", "转换标识"),
    _6("6", "审核"),
    _7("7", "批量修改");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ChangeType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChangeType fromCode(String code) {
        return Stream.of(ChangeType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
