package com.xforceplus.ultraman.app.casservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * config_item_value_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-08
 */
public enum ConfigItemValueType {

    STRING("string", "字符串"),
    NUMBER("number", "数字"),
    LIST("list", "集合");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ConfigItemValueType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ConfigItemValueType fromCode(String code) {
        return Stream.of(ConfigItemValueType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
