package com.xforceplus.ultraman.app.casservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * from_flag
 * </p>
 *
 * @author ultraman
 * @since 2024-07-08
 */
public enum FromFlag {

    _1("1", "文件导入"),
    _2("2", "页面新增"),
    _3("3", "外部接口同步");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    FromFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FromFlag fromCode(String code) {
        return Stream.of(FromFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
