package com.xforceplus.ultraman.app.casservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * retailer_tenant_code
 * </p>
 *
 * @author ultraman
 * @since 2024-07-08
 */
public enum RetailerTenantCode {

    WILMAR("wilmar", "益海嘉里"),
    TQLS("tqls", "铁骑力士"),
    QZDREAM("qzdream", "千织护理");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RetailerTenantCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RetailerTenantCode fromCode(String code) {
        return Stream.of(RetailerTenantCode.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
