package com.xforceplus.ultraman.app.casservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * sales_archives_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-08
 */
public enum SalesArchivesType {

    _0("0", "全部");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SalesArchivesType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SalesArchivesType fromCode(String code) {
        return Stream.of(SalesArchivesType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
