package com.xforceplus.ultraman.app.casservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * strore_info
 * </p>
 *
 * @author ultraman
 * @since 2024-07-08
 */
public enum StroreInfo {

    RTMART("rtmart", "大润发"),
    CRV("crv", "华润万家"),
    SUGUO("suguo", "华润苏果"),
    CRV_O_L_E("crvOLE", "华润OLE"),
    WALMART("walmart", "沃尔玛"),
    SAM("sam", "山姆"),
    METRO("metro", "麦德龙"),
    RENRENLE("renrenle", "人人乐"),
    BJHL("bjhl", "北京华联"),
    WUMART("wumart", "物美"),
    YONGHUI("yonghui", "永辉"),
    DENNIS("dennis", "丹尼斯"),
    JIAJIAYUE("jiajiayue", "家家悦"),
    BBG("bbg", "步步高"),
    HEMA("hema", "盒马"),
    LIKELONG("likelong", "利客隆"),
    LOTUS("lotus", "卜蜂莲花"),
    CENTURYMART("centurymart", "世纪联华"),
    OUYA("ouya", "欧亚"),
    WANGFUJING("wangfujing", "王府井"),
    WUSHANG("wushang", "武商"),
    YINZUO("yinzuo", "银座"),
    HEJIAFU("hejiafu", "合家福"),
    ZBDC("zbdc", "中百仓储"),
    CDC("cdc", "昌大昌"),
    BAIJIAHUA("baijiahua", "百佳华"),
    RAINBOW("rainbow", "天虹"),
    HONGQI("hongqi", "红旗"),
    LIKELAI("likelai", "利客来"),
    ZHONGSHANG("zhongshang", "中商平价");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    StroreInfo(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static StroreInfo fromCode(String code) {
        return Stream.of(StroreInfo.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
