package com.xforceplus.ultraman.app.casservice.metadata.meta;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.xforceplus.ultraman.bocp.gen.typed.TypedField;

/**
* 对象元数据
*
* @author ultraman
* @since 2024-07-08
*/
public class EntityMeta {
    public interface CustomerChannelRelation {
        static Long id() {
            return 1732329334625112065L;
        }
        static String code() {
            return "customerChannelRelation";
        }
        TypedField<String> CUSTOMER_ID = new TypedField<>(String.class, "customerId");
        TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "customerNo");
        TypedField<String> CHANNEL_CODE = new TypedField<>(String.class, "channelCode");
        TypedField<String> CHANNEL_NAME = new TypedField<>(String.class, "channelName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface CustomerProductGroupRelation {
        static Long id() {
            return 1732329666462662657L;
        }
        static String code() {
            return "customerProductGroupRelation";
        }
        TypedField<String> CUSTOMER_ID = new TypedField<>(String.class, "customerId");
        TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "customerNo");
        TypedField<String> PRODUCT_GROUP_CODE = new TypedField<>(String.class, "productGroupCode");
        TypedField<String> PRODUCT_GROUP_NAME = new TypedField<>(String.class, "productGroupName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface CustomerSaleOrganization {
        static Long id() {
            return 1732330059448528898L;
        }
        static String code() {
            return "customerSaleOrganization";
        }
        TypedField<String> CUSTOMER_ID = new TypedField<>(String.class, "customerId");
        TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "customerNo");
        TypedField<String> SALE_ORGANIZATION_CODE = new TypedField<>(String.class, "saleOrganizationCode");
        TypedField<String> SALE_ORGANIZATION_NAME = new TypedField<>(String.class, "saleOrganizationName");
        TypedField<String> COMPANY_CODE = new TypedField<>(String.class, "companyCode");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface SalesArchives {
        static Long id() {
            return 1732340433345888258L;
        }
        static String code() {
            return "salesArchives";
        }
        TypedField<String> CUSTOMER_ID = new TypedField<>(String.class, "customerId");
        TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "customerNo");
        TypedField<String> SALES_ORGNIZATION_CODE = new TypedField<>(String.class, "salesOrgnizationCode");
        TypedField<String> SALES_ORGNIZATION_NAME = new TypedField<>(String.class, "salesOrgnizationName");
        TypedField<String> PRODUCT_GROUP_CODE = new TypedField<>(String.class, "productGroupCode");
        TypedField<String> PRODUCT_GROUP_NAME = new TypedField<>(String.class, "productGroupName");
        TypedField<String> CHANNEL_CODE = new TypedField<>(String.class, "channelCode");
        TypedField<String> CHANNEL_NAME = new TypedField<>(String.class, "channelName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SOLD_TO_PARTY_CODE = new TypedField<>(String.class, "soldToPartyCode");
        TypedField<String> SOLD_TO_PARTY_NAME = new TypedField<>(String.class, "soldToPartyName");
        TypedField<String> SHIP_TO_PARTY_CODE = new TypedField<>(String.class, "shipToPartyCode");
        TypedField<String> SHIP_TO_PARTY_NAME = new TypedField<>(String.class, "shipToPartyName");
        TypedField<String> BILL_TO_PARTY_CODE = new TypedField<>(String.class, "billToPartyCode");
        TypedField<String> BILL_TO_PARTY_NAME = new TypedField<>(String.class, "billToPartyName");
        TypedField<String> PAYER_CODE = new TypedField<>(String.class, "payerCode");
        TypedField<String> PAYER_NAME = new TypedField<>(String.class, "payerName");
        TypedField<String> SALES_ARCHIVES_TYPE = new TypedField<>(String.class, "salesArchivesType");
        TypedField<String> SOURCE = new TypedField<>(String.class, "source");
        TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "customerName");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> FROM_FLAG = new TypedField<>(String.class, "fromFlag");
        /**
         * 对一关联关系 关联对象 orgInfo
         */
        TypedField<Long> ORG_REL_ID = new TypedField<>(Long.class, "orgRel.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface ORG_REL {
                static String code () {
                    return "orgRel" ;
                }
                TypedField<String> CODE = new TypedField<>(String.class, "orgRel.code");
                TypedField<String> NAME = new TypedField<>(String.class, "orgRel.name");
                TypedField<Long> ID = new TypedField<>(Long.class, "orgRel.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "orgRel.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "orgRel.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "orgRel.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "orgRel.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "orgRel.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "orgRel.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "orgRel.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "orgRel.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "orgRel.delete_flag");
            }
        }
        /**
         * 租户定制对象
         */
        interface Tenant {
            interface TQLS {
                TypedField<String> ACCOUNT_SET_NAME = new TypedField<>(String.class, "accountSetName");
                TypedField<String> ACCOUNT_SET_CODE = new TypedField<>(String.class, "accountSetCode");
            }
            interface QZDREAM {
                TypedField<String> PURCHASE_PHONE = new TypedField<>(String.class, "purchasePhone");
            }
        }
    }
    public interface SalesOrgnizationAffiliateInfo {
        static Long id() {
            return 1732635899630555137L;
        }
        static String code() {
            return "salesOrgnizationAffiliateInfo";
        }
        TypedField<String> SALES_ORGNIZATION_CODE = new TypedField<>(String.class, "salesOrgnizationCode");
        TypedField<String> SALES_ORGNIZATION_NAME = new TypedField<>(String.class, "salesOrgnizationName");
        TypedField<String> PRODUCT_GROUP_CODE = new TypedField<>(String.class, "productGroupCode");
        TypedField<String> PRODUCT_GROUP_NAME = new TypedField<>(String.class, "productGroupName");
        TypedField<String> VOUCHER_TYPE = new TypedField<>(String.class, "voucherType");
        TypedField<String> VOUCHER_CURRENCY = new TypedField<>(String.class, "voucherCurrency");
        TypedField<String> SHIPMENT_TYPE = new TypedField<>(String.class, "shipmentType");
        TypedField<String> TRANSPORTATION_MODE_TYPE = new TypedField<>(String.class, "transportationModeType");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> RETURN_VOUCHER_TYPE = new TypedField<>(String.class, "returnVoucherType");
    }
    public interface RetailerSupplierMapping {
        static Long id() {
            return 1732638206927122433L;
        }
        static String code() {
            return "retailerSupplierMapping";
        }
        TypedField<String> RETAILER_CODE = new TypedField<>(String.class, "retailerCode");
        TypedField<String> RETAILER_NAME = new TypedField<>(String.class, "retailerName");
        TypedField<String> STORE_CODE = new TypedField<>(String.class, "storeCode");
        TypedField<String> STORE_NAME = new TypedField<>(String.class, "storeName");
        TypedField<String> SUPPLIER_CODE = new TypedField<>(String.class, "supplierCode");
        TypedField<String> SUPPLIER_NAME = new TypedField<>(String.class, "supplierName");
        TypedField<String> SHIPPED_BY = new TypedField<>(String.class, "shippedBy");
        TypedField<String> WAREHOUSE_CODE = new TypedField<>(String.class, "warehouseCode");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "auditStatus");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> WAREHOUSE_NAME = new TypedField<>(String.class, "warehouseName");
        TypedField<String> SCENE_CODE = new TypedField<>(String.class, "sceneCode");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> SALES_ORGNIZATION_CODE = new TypedField<>(String.class, "salesOrgnizationCode");
        TypedField<String> SALES_ORGNIZATION_NAME = new TypedField<>(String.class, "salesOrgnizationName");
        TypedField<String> AUDITOR = new TypedField<>(String.class, "auditor");
        TypedField<LocalDateTime> AUDITOR_TIME = new TypedField<>(LocalDateTime.class, "auditorTime");
        TypedField<String> STORE_ADDRESS = new TypedField<>(String.class, "storeAddress");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> FROM_FLAG = new TypedField<>(String.class, "fromFlag");
        /**
         * 对一关联关系 关联对象 salesArchives
         */
        TypedField<Long> ONEONE_FOR_SALES_ARCHIVES_ID = new TypedField<>(Long.class, "oneoneForSalesArchives.id");
        /**
         * 对一关联关系 关联对象 purchaseOrgs
         */
        TypedField<Long> SHOP_REL_ID = new TypedField<>(Long.class, "shopRel.id");
        /**
         * 对一关联关系 关联对象 orgInfo
         */
        TypedField<Long> ORG_REL_ID = new TypedField<>(Long.class, "orgRel.id");
        /**
         * 对一关联关系 关联对象 orgSoldToParty
         */
        TypedField<Long> ORG_SOLD_TO_PARTY_REL_ID = new TypedField<>(Long.class, "orgSoldToPartyRel.id");
        /**
         * 对一关联关系 关联对象 orgSoldShipToParty
         */
        TypedField<Long> ORG_SOLD_SHIP_TO_PARTY_REL_ID = new TypedField<>(Long.class, "orgSoldShipToPartyRel.id");
        /**
         * 对一关联关系 关联对象 purchaseOrgs
         */
        TypedField<Long> SUPPLY_REL_ID = new TypedField<>(Long.class, "supplyRel.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface ONEONE_FOR_SALES_ARCHIVES {
                static String code () {
                    return "oneoneForSalesArchives" ;
                }
                TypedField<String> CUSTOMER_ID = new TypedField<>(String.class, "oneoneForSalesArchives.customerId");
                TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "oneoneForSalesArchives.customerNo");
                TypedField<String> SALES_ORGNIZATION_CODE = new TypedField<>(String.class, "oneoneForSalesArchives.salesOrgnizationCode");
                TypedField<String> SALES_ORGNIZATION_NAME = new TypedField<>(String.class, "oneoneForSalesArchives.salesOrgnizationName");
                TypedField<String> PRODUCT_GROUP_CODE = new TypedField<>(String.class, "oneoneForSalesArchives.productGroupCode");
                TypedField<String> PRODUCT_GROUP_NAME = new TypedField<>(String.class, "oneoneForSalesArchives.productGroupName");
                TypedField<String> CHANNEL_CODE = new TypedField<>(String.class, "oneoneForSalesArchives.channelCode");
                TypedField<String> CHANNEL_NAME = new TypedField<>(String.class, "oneoneForSalesArchives.channelName");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneoneForSalesArchives.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneoneForSalesArchives.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneoneForSalesArchives.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneoneForSalesArchives.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneoneForSalesArchives.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneoneForSalesArchives.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneoneForSalesArchives.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneoneForSalesArchives.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneoneForSalesArchives.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneoneForSalesArchives.delete_flag");
                TypedField<String> SOLD_TO_PARTY_CODE = new TypedField<>(String.class, "oneoneForSalesArchives.soldToPartyCode");
                TypedField<String> SOLD_TO_PARTY_NAME = new TypedField<>(String.class, "oneoneForSalesArchives.soldToPartyName");
                TypedField<String> SHIP_TO_PARTY_CODE = new TypedField<>(String.class, "oneoneForSalesArchives.shipToPartyCode");
                TypedField<String> SHIP_TO_PARTY_NAME = new TypedField<>(String.class, "oneoneForSalesArchives.shipToPartyName");
                TypedField<String> BILL_TO_PARTY_CODE = new TypedField<>(String.class, "oneoneForSalesArchives.billToPartyCode");
                TypedField<String> BILL_TO_PARTY_NAME = new TypedField<>(String.class, "oneoneForSalesArchives.billToPartyName");
                TypedField<String> PAYER_CODE = new TypedField<>(String.class, "oneoneForSalesArchives.payerCode");
                TypedField<String> PAYER_NAME = new TypedField<>(String.class, "oneoneForSalesArchives.payerName");
                TypedField<String> SALES_ARCHIVES_TYPE = new TypedField<>(String.class, "oneoneForSalesArchives.salesArchivesType");
                TypedField<String> SOURCE = new TypedField<>(String.class, "oneoneForSalesArchives.source");
                TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "oneoneForSalesArchives.customerName");
                TypedField<String> STATUS = new TypedField<>(String.class, "oneoneForSalesArchives.status");
                TypedField<String> FROM_FLAG = new TypedField<>(String.class, "oneoneForSalesArchives.fromFlag");
            }
            interface SHOP_REL {
                static String code () {
                    return "shopRel" ;
                }
                TypedField<String> PURCHASE_RETAILER_ID = new TypedField<>(String.class, "shopRel.purchaseRetailerId");
                TypedField<String> PURCHASE_RETAILER_NAME = new TypedField<>(String.class, "shopRel.purchaseRetailerName");
                TypedField<String> S_SALES_ORGANIZATION_CODE = new TypedField<>(String.class, "shopRel.sSalesOrganizationCode");
                TypedField<String> S_SALES_ORGANIZATION_NAME = new TypedField<>(String.class, "shopRel.sSalesOrganizationName");
                TypedField<String> PURCHASE_STORE_CODE = new TypedField<>(String.class, "shopRel.purchaseStoreCode");
                TypedField<String> PURCHASE_STORE_NAME = new TypedField<>(String.class, "shopRel.purchaseStoreName");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "shopRel.sellerCode");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "shopRel.sellerName");
                TypedField<String> ACTIVE_STATUS = new TypedField<>(String.class, "shopRel.activeStatus");
                TypedField<String> CONVERSION_STATUS = new TypedField<>(String.class, "shopRel.conversionStatus");
                TypedField<Long> ID = new TypedField<>(Long.class, "shopRel.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "shopRel.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "shopRel.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "shopRel.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "shopRel.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "shopRel.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "shopRel.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "shopRel.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "shopRel.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "shopRel.delete_flag");
                TypedField<String> TAB_CODE = new TypedField<>(String.class, "shopRel.tabCode");
                TypedField<String> PURCHASE_STORE_ADDRESS = new TypedField<>(String.class, "shopRel.purchaseStoreAddress");
                TypedField<String> FROM_FLAG = new TypedField<>(String.class, "shopRel.fromFlag");
            }
            interface ORG_REL {
                static String code () {
                    return "orgRel" ;
                }
                TypedField<String> CODE = new TypedField<>(String.class, "orgRel.code");
                TypedField<String> NAME = new TypedField<>(String.class, "orgRel.name");
                TypedField<Long> ID = new TypedField<>(Long.class, "orgRel.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "orgRel.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "orgRel.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "orgRel.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "orgRel.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "orgRel.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "orgRel.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "orgRel.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "orgRel.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "orgRel.delete_flag");
            }
            interface ORG_SOLD_TO_PARTY_REL {
                static String code () {
                    return "orgSoldToPartyRel" ;
                }
                TypedField<String> SALES_ORGNIZATION_CODE = new TypedField<>(String.class, "orgSoldToPartyRel.salesOrgnizationCode");
                TypedField<String> SALES_ORGNIZATION_NAME = new TypedField<>(String.class, "orgSoldToPartyRel.salesOrgnizationName");
                TypedField<String> SOLD_TO_PARTY_CODE = new TypedField<>(String.class, "orgSoldToPartyRel.soldToPartyCode");
                TypedField<String> SOLD_TO_PARTY_NAME = new TypedField<>(String.class, "orgSoldToPartyRel.soldToPartyName");
                TypedField<Long> ID = new TypedField<>(Long.class, "orgSoldToPartyRel.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "orgSoldToPartyRel.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "orgSoldToPartyRel.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "orgSoldToPartyRel.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "orgSoldToPartyRel.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "orgSoldToPartyRel.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "orgSoldToPartyRel.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "orgSoldToPartyRel.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "orgSoldToPartyRel.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "orgSoldToPartyRel.delete_flag");
            }
            interface ORG_SOLD_SHIP_TO_PARTY_REL {
                static String code () {
                    return "orgSoldShipToPartyRel" ;
                }
                TypedField<String> SALES_ORGNIZATION_CODE = new TypedField<>(String.class, "orgSoldShipToPartyRel.salesOrgnizationCode");
                TypedField<String> SALES_ORGNIZATION_NAME = new TypedField<>(String.class, "orgSoldShipToPartyRel.salesOrgnizationName");
                TypedField<String> SOLD_TO_PARTY_CODE = new TypedField<>(String.class, "orgSoldShipToPartyRel.soldToPartyCode");
                TypedField<String> SOLD_TO_PARTY_NAME = new TypedField<>(String.class, "orgSoldShipToPartyRel.soldToPartyName");
                TypedField<Long> ID = new TypedField<>(Long.class, "orgSoldShipToPartyRel.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "orgSoldShipToPartyRel.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "orgSoldShipToPartyRel.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "orgSoldShipToPartyRel.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "orgSoldShipToPartyRel.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "orgSoldShipToPartyRel.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "orgSoldShipToPartyRel.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "orgSoldShipToPartyRel.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "orgSoldShipToPartyRel.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "orgSoldShipToPartyRel.delete_flag");
                TypedField<String> SHIP_TO_PARTY_NAME = new TypedField<>(String.class, "orgSoldShipToPartyRel.shipToPartyName");
                TypedField<String> SHIP_TO_PARTY_CODE = new TypedField<>(String.class, "orgSoldShipToPartyRel.shipToPartyCode");
            }
            interface SUPPLY_REL {
                static String code () {
                    return "supplyRel" ;
                }
                TypedField<String> PURCHASE_RETAILER_ID = new TypedField<>(String.class, "supplyRel.purchaseRetailerId");
                TypedField<String> PURCHASE_RETAILER_NAME = new TypedField<>(String.class, "supplyRel.purchaseRetailerName");
                TypedField<String> S_SALES_ORGANIZATION_CODE = new TypedField<>(String.class, "supplyRel.sSalesOrganizationCode");
                TypedField<String> S_SALES_ORGANIZATION_NAME = new TypedField<>(String.class, "supplyRel.sSalesOrganizationName");
                TypedField<String> PURCHASE_STORE_CODE = new TypedField<>(String.class, "supplyRel.purchaseStoreCode");
                TypedField<String> PURCHASE_STORE_NAME = new TypedField<>(String.class, "supplyRel.purchaseStoreName");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "supplyRel.sellerCode");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "supplyRel.sellerName");
                TypedField<String> ACTIVE_STATUS = new TypedField<>(String.class, "supplyRel.activeStatus");
                TypedField<String> CONVERSION_STATUS = new TypedField<>(String.class, "supplyRel.conversionStatus");
                TypedField<Long> ID = new TypedField<>(Long.class, "supplyRel.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "supplyRel.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "supplyRel.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "supplyRel.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "supplyRel.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "supplyRel.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "supplyRel.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "supplyRel.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "supplyRel.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "supplyRel.delete_flag");
                TypedField<String> TAB_CODE = new TypedField<>(String.class, "supplyRel.tabCode");
                TypedField<String> PURCHASE_STORE_ADDRESS = new TypedField<>(String.class, "supplyRel.purchaseStoreAddress");
                TypedField<String> FROM_FLAG = new TypedField<>(String.class, "supplyRel.fromFlag");
            }
        }
        /**
         * 租户定制对象
         */
        interface Tenant {
            interface TQLS {
            }
            interface QZDREAM {
            }
        }
    }
    public interface SalesArchivesChangedHistory {
        static Long id() {
            return 1733004784053620737L;
        }
        static String code() {
            return "salesArchivesChangedHistory";
        }
        TypedField<String> OPERATION_USER = new TypedField<>(String.class, "operationUser");
        TypedField<LocalDateTime> OPERATION_TIME = new TypedField<>(LocalDateTime.class, "operationTime");
        TypedField<String> OPERATION_CONTENT = new TypedField<>(String.class, "operationContent");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联关系 关联对象 salesArchives
         */
        TypedField<Long> ONE_TO_MANY_FOR_CHANGED_HISTORY_ID = new TypedField<>(Long.class, "oneToManyForChangedHistory.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface ONE_TO_MANY_FOR_CHANGED_HISTORY {
                static String code () {
                    return "oneToManyForChangedHistory" ;
                }
                TypedField<String> CUSTOMER_ID = new TypedField<>(String.class, "oneToManyForChangedHistory.customerId");
                TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "oneToManyForChangedHistory.customerNo");
                TypedField<String> SALES_ORGNIZATION_CODE = new TypedField<>(String.class, "oneToManyForChangedHistory.salesOrgnizationCode");
                TypedField<String> SALES_ORGNIZATION_NAME = new TypedField<>(String.class, "oneToManyForChangedHistory.salesOrgnizationName");
                TypedField<String> PRODUCT_GROUP_CODE = new TypedField<>(String.class, "oneToManyForChangedHistory.productGroupCode");
                TypedField<String> PRODUCT_GROUP_NAME = new TypedField<>(String.class, "oneToManyForChangedHistory.productGroupName");
                TypedField<String> CHANNEL_CODE = new TypedField<>(String.class, "oneToManyForChangedHistory.channelCode");
                TypedField<String> CHANNEL_NAME = new TypedField<>(String.class, "oneToManyForChangedHistory.channelName");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneToManyForChangedHistory.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneToManyForChangedHistory.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneToManyForChangedHistory.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneToManyForChangedHistory.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneToManyForChangedHistory.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneToManyForChangedHistory.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneToManyForChangedHistory.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneToManyForChangedHistory.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneToManyForChangedHistory.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneToManyForChangedHistory.delete_flag");
                TypedField<String> SOLD_TO_PARTY_CODE = new TypedField<>(String.class, "oneToManyForChangedHistory.soldToPartyCode");
                TypedField<String> SOLD_TO_PARTY_NAME = new TypedField<>(String.class, "oneToManyForChangedHistory.soldToPartyName");
                TypedField<String> SHIP_TO_PARTY_CODE = new TypedField<>(String.class, "oneToManyForChangedHistory.shipToPartyCode");
                TypedField<String> SHIP_TO_PARTY_NAME = new TypedField<>(String.class, "oneToManyForChangedHistory.shipToPartyName");
                TypedField<String> BILL_TO_PARTY_CODE = new TypedField<>(String.class, "oneToManyForChangedHistory.billToPartyCode");
                TypedField<String> BILL_TO_PARTY_NAME = new TypedField<>(String.class, "oneToManyForChangedHistory.billToPartyName");
                TypedField<String> PAYER_CODE = new TypedField<>(String.class, "oneToManyForChangedHistory.payerCode");
                TypedField<String> PAYER_NAME = new TypedField<>(String.class, "oneToManyForChangedHistory.payerName");
                TypedField<String> SALES_ARCHIVES_TYPE = new TypedField<>(String.class, "oneToManyForChangedHistory.salesArchivesType");
                TypedField<String> SOURCE = new TypedField<>(String.class, "oneToManyForChangedHistory.source");
                TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "oneToManyForChangedHistory.customerName");
                TypedField<String> STATUS = new TypedField<>(String.class, "oneToManyForChangedHistory.status");
                TypedField<String> FROM_FLAG = new TypedField<>(String.class, "oneToManyForChangedHistory.fromFlag");
            }
        }
    }
    public interface SalesArchivesForConfig {
        static Long id() {
            return 1734474521750614017L;
        }
        static String code() {
            return "salesArchivesForConfig";
        }
        TypedField<String> CUSTOMER_ID = new TypedField<>(String.class, "customerId");
        TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "customerNo");
        TypedField<String> SALES_ORGNIZATION_CODE = new TypedField<>(String.class, "salesOrgnizationCode");
        TypedField<String> SALES_ORGNIZATION_NAME = new TypedField<>(String.class, "salesOrgnizationName");
        TypedField<String> PRODUCT_GROUP_CODE = new TypedField<>(String.class, "productGroupCode");
        TypedField<String> PRODUCT_GROUP_NAME = new TypedField<>(String.class, "productGroupName");
        TypedField<String> CHANNEL_CODE = new TypedField<>(String.class, "channelCode");
        TypedField<String> CHANNEL_NAME = new TypedField<>(String.class, "channelName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SOLD_TO_PARTY_CODE = new TypedField<>(String.class, "soldToPartyCode");
        TypedField<String> SOLD_TO_PARTY_NAME = new TypedField<>(String.class, "soldToPartyName");
        TypedField<String> SHIP_TO_PARTY_CODE = new TypedField<>(String.class, "shipToPartyCode");
        TypedField<String> SHIP_TO_PARTY_NAME = new TypedField<>(String.class, "shipToPartyName");
        TypedField<String> BILL_TO_PARTY_CODE = new TypedField<>(String.class, "billToPartyCode");
        TypedField<String> BILL_TO_PARTY_NAME = new TypedField<>(String.class, "billToPartyName");
        TypedField<String> PAYER_CODE = new TypedField<>(String.class, "payerCode");
        TypedField<String> PAYER_NAME = new TypedField<>(String.class, "payerName");
        TypedField<String> SALES_ARCHIVES_TYPE = new TypedField<>(String.class, "salesArchivesType");
        TypedField<String> SOURCE = new TypedField<>(String.class, "source");
        TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "customerName");
        /**
         * 对一关联关系 关联对象 retailerSupplierMapping
         */
        TypedField<Long> ONEMANY_FOR_SALES_ARCHIVES_ID = new TypedField<>(Long.class, "onemanyForSalesArchives.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface ONEMANY_FOR_SALES_ARCHIVES {
                static String code () {
                    return "onemanyForSalesArchives" ;
                }
                TypedField<String> RETAILER_CODE = new TypedField<>(String.class, "onemanyForSalesArchives.retailerCode");
                TypedField<String> RETAILER_NAME = new TypedField<>(String.class, "onemanyForSalesArchives.retailerName");
                TypedField<String> STORE_CODE = new TypedField<>(String.class, "onemanyForSalesArchives.storeCode");
                TypedField<String> STORE_NAME = new TypedField<>(String.class, "onemanyForSalesArchives.storeName");
                TypedField<String> SUPPLIER_CODE = new TypedField<>(String.class, "onemanyForSalesArchives.supplierCode");
                TypedField<String> SUPPLIER_NAME = new TypedField<>(String.class, "onemanyForSalesArchives.supplierName");
                TypedField<String> SHIPPED_BY = new TypedField<>(String.class, "onemanyForSalesArchives.shippedBy");
                TypedField<String> WAREHOUSE_CODE = new TypedField<>(String.class, "onemanyForSalesArchives.warehouseCode");
                TypedField<String> STATUS = new TypedField<>(String.class, "onemanyForSalesArchives.status");
                TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "onemanyForSalesArchives.auditStatus");
                TypedField<Long> ID = new TypedField<>(Long.class, "onemanyForSalesArchives.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "onemanyForSalesArchives.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "onemanyForSalesArchives.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "onemanyForSalesArchives.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "onemanyForSalesArchives.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "onemanyForSalesArchives.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "onemanyForSalesArchives.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "onemanyForSalesArchives.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "onemanyForSalesArchives.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "onemanyForSalesArchives.delete_flag");
                TypedField<String> WAREHOUSE_NAME = new TypedField<>(String.class, "onemanyForSalesArchives.warehouseName");
                TypedField<String> SCENE_CODE = new TypedField<>(String.class, "onemanyForSalesArchives.sceneCode");
                TypedField<String> EXT1 = new TypedField<>(String.class, "onemanyForSalesArchives.ext1");
                TypedField<String> SALES_ORGNIZATION_CODE = new TypedField<>(String.class, "onemanyForSalesArchives.salesOrgnizationCode");
                TypedField<String> SALES_ORGNIZATION_NAME = new TypedField<>(String.class, "onemanyForSalesArchives.salesOrgnizationName");
                TypedField<String> AUDITOR = new TypedField<>(String.class, "onemanyForSalesArchives.auditor");
                TypedField<LocalDateTime> AUDITOR_TIME = new TypedField<>(LocalDateTime.class, "onemanyForSalesArchives.auditorTime");
                TypedField<String> STORE_ADDRESS = new TypedField<>(String.class, "onemanyForSalesArchives.storeAddress");
                TypedField<String> EXT2 = new TypedField<>(String.class, "onemanyForSalesArchives.ext2");
                TypedField<String> FROM_FLAG = new TypedField<>(String.class, "onemanyForSalesArchives.fromFlag");
            }
        }
    }
    public interface SceneCodeAndSalesArchivesTypeMapping {
        static Long id() {
            return 1735122732952162305L;
        }
        static String code() {
            return "sceneCodeAndSalesArchivesTypeMapping";
        }
        TypedField<String> SCENE_CODE = new TypedField<>(String.class, "sceneCode");
        TypedField<String> SALES_ARCHIVE_TYPE = new TypedField<>(String.class, "salesArchiveType");
        TypedField<String> NOTE = new TypedField<>(String.class, "note");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface ConfigRule {
        static Long id() {
            return 1737665625343397890L;
        }
        static String code() {
            return "configRule";
        }
        TypedField<String> RULE_TYPE = new TypedField<>(String.class, "ruleType");
        TypedField<String> SCENE_CODE = new TypedField<>(String.class, "sceneCode");
        TypedField<String> CONFIG_CONTENT = new TypedField<>(String.class, "configContent");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface ConfigRuleTemplate {
        static Long id() {
            return 1737667719927492609L;
        }
        static String code() {
            return "configRuleTemplate";
        }
        TypedField<String> CONFIG_RULE_TYPE = new TypedField<>(String.class, "configRuleType");
        TypedField<String> GROUP = new TypedField<>(String.class, "group");
        TypedField<String> CONFIG_ITEM_CODE = new TypedField<>(String.class, "configItemCode");
        TypedField<String> CONFIG_ITEM_NAME = new TypedField<>(String.class, "configItemName");
        TypedField<String> CONFIG_ITEM_VALUE_TYPE = new TypedField<>(String.class, "configItemValueType");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface StoreInfo {
        static Long id() {
            return 1743105666337853442L;
        }
        static String code() {
            return "storeInfo";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface PurchaseOrgs {
        static Long id() {
            return 1743187843868119042L;
        }
        static String code() {
            return "purchaseOrgs";
        }
        TypedField<String> PURCHASE_RETAILER_ID = new TypedField<>(String.class, "purchaseRetailerId");
        TypedField<String> PURCHASE_RETAILER_NAME = new TypedField<>(String.class, "purchaseRetailerName");
        TypedField<String> S_SALES_ORGANIZATION_CODE = new TypedField<>(String.class, "sSalesOrganizationCode");
        TypedField<String> S_SALES_ORGANIZATION_NAME = new TypedField<>(String.class, "sSalesOrganizationName");
        TypedField<String> PURCHASE_STORE_CODE = new TypedField<>(String.class, "purchaseStoreCode");
        TypedField<String> PURCHASE_STORE_NAME = new TypedField<>(String.class, "purchaseStoreName");
        TypedField<String> SELLER_CODE = new TypedField<>(String.class, "sellerCode");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> ACTIVE_STATUS = new TypedField<>(String.class, "activeStatus");
        TypedField<String> CONVERSION_STATUS = new TypedField<>(String.class, "conversionStatus");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TAB_CODE = new TypedField<>(String.class, "tabCode");
        TypedField<String> PURCHASE_STORE_ADDRESS = new TypedField<>(String.class, "purchaseStoreAddress");
        TypedField<String> FROM_FLAG = new TypedField<>(String.class, "fromFlag");
        /**
         * 对一关联关系 关联对象 orgInfo
         */
        TypedField<Long> PURCHASE_ORG_ID = new TypedField<>(Long.class, "purchaseOrg.id");
        /**
         * 对一关联关系 关联对象 orgInfo
         */
        TypedField<Long> SALES_ORGNIZATION_CODE_REL_ID = new TypedField<>(Long.class, "salesOrgnizationCodeRel.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface PURCHASE_ORG {
                static String code () {
                    return "purchaseOrg" ;
                }
                TypedField<String> CODE = new TypedField<>(String.class, "purchaseOrg.code");
                TypedField<String> NAME = new TypedField<>(String.class, "purchaseOrg.name");
                TypedField<Long> ID = new TypedField<>(Long.class, "purchaseOrg.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "purchaseOrg.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "purchaseOrg.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "purchaseOrg.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "purchaseOrg.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "purchaseOrg.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "purchaseOrg.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "purchaseOrg.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "purchaseOrg.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "purchaseOrg.delete_flag");
            }
            interface SALES_ORGNIZATION_CODE_REL {
                static String code () {
                    return "salesOrgnizationCodeRel" ;
                }
                TypedField<String> CODE = new TypedField<>(String.class, "salesOrgnizationCodeRel.code");
                TypedField<String> NAME = new TypedField<>(String.class, "salesOrgnizationCodeRel.name");
                TypedField<Long> ID = new TypedField<>(Long.class, "salesOrgnizationCodeRel.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "salesOrgnizationCodeRel.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "salesOrgnizationCodeRel.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "salesOrgnizationCodeRel.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "salesOrgnizationCodeRel.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "salesOrgnizationCodeRel.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "salesOrgnizationCodeRel.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "salesOrgnizationCodeRel.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "salesOrgnizationCodeRel.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "salesOrgnizationCodeRel.delete_flag");
            }
        }
    }
    public interface OrgInfo {
        static Long id() {
            return 1743471004685963265L;
        }
        static String code() {
            return "orgInfo";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface OrgSoldToParty {
        static Long id() {
            return 1750049751584780289L;
        }
        static String code() {
            return "orgSoldToParty";
        }
        TypedField<String> SALES_ORGNIZATION_CODE = new TypedField<>(String.class, "salesOrgnizationCode");
        TypedField<String> SALES_ORGNIZATION_NAME = new TypedField<>(String.class, "salesOrgnizationName");
        TypedField<String> SOLD_TO_PARTY_CODE = new TypedField<>(String.class, "soldToPartyCode");
        TypedField<String> SOLD_TO_PARTY_NAME = new TypedField<>(String.class, "soldToPartyName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联关系 关联对象 orgInfo
         */
        TypedField<Long> SALES_ORGNIZATION_CODE_REL_ID = new TypedField<>(Long.class, "salesOrgnizationCodeRel.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface SALES_ORGNIZATION_CODE_REL {
                static String code () {
                    return "salesOrgnizationCodeRel" ;
                }
                TypedField<String> CODE = new TypedField<>(String.class, "salesOrgnizationCodeRel.code");
                TypedField<String> NAME = new TypedField<>(String.class, "salesOrgnizationCodeRel.name");
                TypedField<Long> ID = new TypedField<>(Long.class, "salesOrgnizationCodeRel.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "salesOrgnizationCodeRel.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "salesOrgnizationCodeRel.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "salesOrgnizationCodeRel.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "salesOrgnizationCodeRel.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "salesOrgnizationCodeRel.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "salesOrgnizationCodeRel.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "salesOrgnizationCodeRel.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "salesOrgnizationCodeRel.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "salesOrgnizationCodeRel.delete_flag");
            }
        }
    }
    public interface OrgSoldShipToParty {
        static Long id() {
            return 1750049789826367490L;
        }
        static String code() {
            return "orgSoldShipToParty";
        }
        TypedField<String> SALES_ORGNIZATION_CODE = new TypedField<>(String.class, "salesOrgnizationCode");
        TypedField<String> SALES_ORGNIZATION_NAME = new TypedField<>(String.class, "salesOrgnizationName");
        TypedField<String> SOLD_TO_PARTY_CODE = new TypedField<>(String.class, "soldToPartyCode");
        TypedField<String> SOLD_TO_PARTY_NAME = new TypedField<>(String.class, "soldToPartyName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SHIP_TO_PARTY_NAME = new TypedField<>(String.class, "shipToPartyName");
        TypedField<String> SHIP_TO_PARTY_CODE = new TypedField<>(String.class, "shipToPartyCode");
        /**
         * 对一关联关系 关联对象 orgInfo
         */
        TypedField<Long> SALES_ORGNIZATION_CODE_REL_ID = new TypedField<>(Long.class, "salesOrgnizationCodeRel.id");
        /**
         * 对一关联关系 关联对象 orgSoldToParty
         */
        TypedField<Long> SOLD_TO_PARTY_REL_ID = new TypedField<>(Long.class, "soldToPartyRel.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface SALES_ORGNIZATION_CODE_REL {
                static String code () {
                    return "salesOrgnizationCodeRel" ;
                }
                TypedField<String> CODE = new TypedField<>(String.class, "salesOrgnizationCodeRel.code");
                TypedField<String> NAME = new TypedField<>(String.class, "salesOrgnizationCodeRel.name");
                TypedField<Long> ID = new TypedField<>(Long.class, "salesOrgnizationCodeRel.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "salesOrgnizationCodeRel.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "salesOrgnizationCodeRel.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "salesOrgnizationCodeRel.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "salesOrgnizationCodeRel.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "salesOrgnizationCodeRel.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "salesOrgnizationCodeRel.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "salesOrgnizationCodeRel.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "salesOrgnizationCodeRel.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "salesOrgnizationCodeRel.delete_flag");
            }
            interface SOLD_TO_PARTY_REL {
                static String code () {
                    return "soldToPartyRel" ;
                }
                TypedField<String> SALES_ORGNIZATION_CODE = new TypedField<>(String.class, "soldToPartyRel.salesOrgnizationCode");
                TypedField<String> SALES_ORGNIZATION_NAME = new TypedField<>(String.class, "soldToPartyRel.salesOrgnizationName");
                TypedField<String> SOLD_TO_PARTY_CODE = new TypedField<>(String.class, "soldToPartyRel.soldToPartyCode");
                TypedField<String> SOLD_TO_PARTY_NAME = new TypedField<>(String.class, "soldToPartyRel.soldToPartyName");
                TypedField<Long> ID = new TypedField<>(Long.class, "soldToPartyRel.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "soldToPartyRel.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "soldToPartyRel.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "soldToPartyRel.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "soldToPartyRel.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "soldToPartyRel.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "soldToPartyRel.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "soldToPartyRel.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "soldToPartyRel.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "soldToPartyRel.delete_flag");
            }
        }
    }
    public interface ChangeHistory {
        static Long id() {
            return 1781199674119614466L;
        }
        static String code() {
            return "changeHistory";
        }
        TypedField<String> YEAR = new TypedField<>(String.class, "year");
        TypedField<String> MONTH = new TypedField<>(String.class, "month");
        TypedField<String> CONTENT = new TypedField<>(String.class, "content");
        TypedField<String> TABLE_CODE = new TypedField<>(String.class, "tableCode");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CHANGE_TYPE = new TypedField<>(String.class, "changeType");
        TypedField<Long> MAIN_DATA_ID = new TypedField<>(Long.class, "mainDataId");
        /**
         * 对一关联关系 关联对象 retailerSupplierMapping
         */
        TypedField<Long> CHANGE_LOG_REL_ID = new TypedField<>(Long.class, "changeLogRel.id");
        /**
         * 对一关联关系 关联对象 salesArchives
         */
        TypedField<Long> CHANGE_LOG_SALES_ARCHIVES_REL_ID = new TypedField<>(Long.class, "changeLogSalesArchivesRel.id");
        /**
         * 对一关联关系 关联对象 purchaseOrgs
         */
        TypedField<Long> CHANGE_LOG_PURCHASE_ORG_REL_ID = new TypedField<>(Long.class, "changeLogPurchaseOrgRel.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface CHANGE_LOG_REL {
                static String code () {
                    return "changeLogRel" ;
                }
                TypedField<String> RETAILER_CODE = new TypedField<>(String.class, "changeLogRel.retailerCode");
                TypedField<String> RETAILER_NAME = new TypedField<>(String.class, "changeLogRel.retailerName");
                TypedField<String> STORE_CODE = new TypedField<>(String.class, "changeLogRel.storeCode");
                TypedField<String> STORE_NAME = new TypedField<>(String.class, "changeLogRel.storeName");
                TypedField<String> SUPPLIER_CODE = new TypedField<>(String.class, "changeLogRel.supplierCode");
                TypedField<String> SUPPLIER_NAME = new TypedField<>(String.class, "changeLogRel.supplierName");
                TypedField<String> SHIPPED_BY = new TypedField<>(String.class, "changeLogRel.shippedBy");
                TypedField<String> WAREHOUSE_CODE = new TypedField<>(String.class, "changeLogRel.warehouseCode");
                TypedField<String> STATUS = new TypedField<>(String.class, "changeLogRel.status");
                TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "changeLogRel.auditStatus");
                TypedField<Long> ID = new TypedField<>(Long.class, "changeLogRel.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "changeLogRel.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "changeLogRel.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "changeLogRel.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "changeLogRel.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "changeLogRel.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "changeLogRel.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "changeLogRel.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "changeLogRel.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "changeLogRel.delete_flag");
                TypedField<String> WAREHOUSE_NAME = new TypedField<>(String.class, "changeLogRel.warehouseName");
                TypedField<String> SCENE_CODE = new TypedField<>(String.class, "changeLogRel.sceneCode");
                TypedField<String> EXT1 = new TypedField<>(String.class, "changeLogRel.ext1");
                TypedField<String> SALES_ORGNIZATION_CODE = new TypedField<>(String.class, "changeLogRel.salesOrgnizationCode");
                TypedField<String> SALES_ORGNIZATION_NAME = new TypedField<>(String.class, "changeLogRel.salesOrgnizationName");
                TypedField<String> AUDITOR = new TypedField<>(String.class, "changeLogRel.auditor");
                TypedField<LocalDateTime> AUDITOR_TIME = new TypedField<>(LocalDateTime.class, "changeLogRel.auditorTime");
                TypedField<String> STORE_ADDRESS = new TypedField<>(String.class, "changeLogRel.storeAddress");
                TypedField<String> EXT2 = new TypedField<>(String.class, "changeLogRel.ext2");
                TypedField<String> FROM_FLAG = new TypedField<>(String.class, "changeLogRel.fromFlag");
            }
            interface CHANGE_LOG_SALES_ARCHIVES_REL {
                static String code () {
                    return "changeLogSalesArchivesRel" ;
                }
                TypedField<String> CUSTOMER_ID = new TypedField<>(String.class, "changeLogSalesArchivesRel.customerId");
                TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "changeLogSalesArchivesRel.customerNo");
                TypedField<String> SALES_ORGNIZATION_CODE = new TypedField<>(String.class, "changeLogSalesArchivesRel.salesOrgnizationCode");
                TypedField<String> SALES_ORGNIZATION_NAME = new TypedField<>(String.class, "changeLogSalesArchivesRel.salesOrgnizationName");
                TypedField<String> PRODUCT_GROUP_CODE = new TypedField<>(String.class, "changeLogSalesArchivesRel.productGroupCode");
                TypedField<String> PRODUCT_GROUP_NAME = new TypedField<>(String.class, "changeLogSalesArchivesRel.productGroupName");
                TypedField<String> CHANNEL_CODE = new TypedField<>(String.class, "changeLogSalesArchivesRel.channelCode");
                TypedField<String> CHANNEL_NAME = new TypedField<>(String.class, "changeLogSalesArchivesRel.channelName");
                TypedField<Long> ID = new TypedField<>(Long.class, "changeLogSalesArchivesRel.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "changeLogSalesArchivesRel.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "changeLogSalesArchivesRel.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "changeLogSalesArchivesRel.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "changeLogSalesArchivesRel.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "changeLogSalesArchivesRel.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "changeLogSalesArchivesRel.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "changeLogSalesArchivesRel.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "changeLogSalesArchivesRel.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "changeLogSalesArchivesRel.delete_flag");
                TypedField<String> SOLD_TO_PARTY_CODE = new TypedField<>(String.class, "changeLogSalesArchivesRel.soldToPartyCode");
                TypedField<String> SOLD_TO_PARTY_NAME = new TypedField<>(String.class, "changeLogSalesArchivesRel.soldToPartyName");
                TypedField<String> SHIP_TO_PARTY_CODE = new TypedField<>(String.class, "changeLogSalesArchivesRel.shipToPartyCode");
                TypedField<String> SHIP_TO_PARTY_NAME = new TypedField<>(String.class, "changeLogSalesArchivesRel.shipToPartyName");
                TypedField<String> BILL_TO_PARTY_CODE = new TypedField<>(String.class, "changeLogSalesArchivesRel.billToPartyCode");
                TypedField<String> BILL_TO_PARTY_NAME = new TypedField<>(String.class, "changeLogSalesArchivesRel.billToPartyName");
                TypedField<String> PAYER_CODE = new TypedField<>(String.class, "changeLogSalesArchivesRel.payerCode");
                TypedField<String> PAYER_NAME = new TypedField<>(String.class, "changeLogSalesArchivesRel.payerName");
                TypedField<String> SALES_ARCHIVES_TYPE = new TypedField<>(String.class, "changeLogSalesArchivesRel.salesArchivesType");
                TypedField<String> SOURCE = new TypedField<>(String.class, "changeLogSalesArchivesRel.source");
                TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "changeLogSalesArchivesRel.customerName");
                TypedField<String> STATUS = new TypedField<>(String.class, "changeLogSalesArchivesRel.status");
                TypedField<String> FROM_FLAG = new TypedField<>(String.class, "changeLogSalesArchivesRel.fromFlag");
            }
            interface CHANGE_LOG_PURCHASE_ORG_REL {
                static String code () {
                    return "changeLogPurchaseOrgRel" ;
                }
                TypedField<String> PURCHASE_RETAILER_ID = new TypedField<>(String.class, "changeLogPurchaseOrgRel.purchaseRetailerId");
                TypedField<String> PURCHASE_RETAILER_NAME = new TypedField<>(String.class, "changeLogPurchaseOrgRel.purchaseRetailerName");
                TypedField<String> S_SALES_ORGANIZATION_CODE = new TypedField<>(String.class, "changeLogPurchaseOrgRel.sSalesOrganizationCode");
                TypedField<String> S_SALES_ORGANIZATION_NAME = new TypedField<>(String.class, "changeLogPurchaseOrgRel.sSalesOrganizationName");
                TypedField<String> PURCHASE_STORE_CODE = new TypedField<>(String.class, "changeLogPurchaseOrgRel.purchaseStoreCode");
                TypedField<String> PURCHASE_STORE_NAME = new TypedField<>(String.class, "changeLogPurchaseOrgRel.purchaseStoreName");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "changeLogPurchaseOrgRel.sellerCode");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "changeLogPurchaseOrgRel.sellerName");
                TypedField<String> ACTIVE_STATUS = new TypedField<>(String.class, "changeLogPurchaseOrgRel.activeStatus");
                TypedField<String> CONVERSION_STATUS = new TypedField<>(String.class, "changeLogPurchaseOrgRel.conversionStatus");
                TypedField<Long> ID = new TypedField<>(Long.class, "changeLogPurchaseOrgRel.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "changeLogPurchaseOrgRel.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "changeLogPurchaseOrgRel.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "changeLogPurchaseOrgRel.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "changeLogPurchaseOrgRel.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "changeLogPurchaseOrgRel.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "changeLogPurchaseOrgRel.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "changeLogPurchaseOrgRel.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "changeLogPurchaseOrgRel.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "changeLogPurchaseOrgRel.delete_flag");
                TypedField<String> TAB_CODE = new TypedField<>(String.class, "changeLogPurchaseOrgRel.tabCode");
                TypedField<String> PURCHASE_STORE_ADDRESS = new TypedField<>(String.class, "changeLogPurchaseOrgRel.purchaseStoreAddress");
                TypedField<String> FROM_FLAG = new TypedField<>(String.class, "changeLogPurchaseOrgRel.fromFlag");
            }
        }
    }
    public interface ConfigInfo {
        static Long id() {
            return 1791021858943520770L;
        }
        static String code() {
            return "configInfo";
        }
        TypedField<String> CONFIG_KEY = new TypedField<>(String.class, "configKey");
        TypedField<String> CONFIG_VAL = new TypedField<>(String.class, "configVal");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface RetailerConfig {
        static Long id() {
            return 1792785556815540226L;
        }
        static String code() {
            return "retailerConfig";
        }
        TypedField<String> BIZ_TENANT_CODE = new TypedField<>(String.class, "bizTenantCode");
        TypedField<String> RETAILER_CODE = new TypedField<>(String.class, "retailerCode");
        TypedField<String> RETAILER_NAME = new TypedField<>(String.class, "retailerName");
        TypedField<String> BUSINESS_CODE = new TypedField<>(String.class, "businessCode");
        TypedField<LocalDateTime> START_DATE = new TypedField<>(LocalDateTime.class, "startDate");
        TypedField<LocalDateTime> END_DATE = new TypedField<>(LocalDateTime.class, "endDate");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface BusinessProductMapping {
        static Long id() {
            return 1792810983462334465L;
        }
        static String code() {
            return "businessProductMapping";
        }
        TypedField<String> BUSINESS_CODE = new TypedField<>(String.class, "businessCode");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface CacheInfo {
        static Long id() {
            return 1793820196103843841L;
        }
        static String code() {
            return "cacheInfo";
        }
        TypedField<String> CACHE_KEY = new TypedField<>(String.class, "cacheKey");
        TypedField<String> CACHE_VALUE = new TypedField<>(String.class, "cacheValue");
        TypedField<LocalDateTime> EXPIRE_TIME = new TypedField<>(LocalDateTime.class, "expireTime");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface StatisticApiInfo {
        static Long id() {
            return 1810197101569642498L;
        }
        static String code() {
            return "statisticApiInfo";
        }
        TypedField<String> CLASS_NAME = new TypedField<>(String.class, "className");
        TypedField<String> METHOD_NAME = new TypedField<>(String.class, "methodName");
        TypedField<String> DAY = new TypedField<>(String.class, "day");
        TypedField<String> NUM = new TypedField<>(String.class, "num");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
}
