package com.xforceplus.ultraman.app.casservice.metadata.validator;

import com.xforceplus.ultraman.app.casservice.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.casservice.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-07-08
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(RetailerSupplierMappingStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RetailerSupplierMappingStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RetailerSupplierMappingStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AuditStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuditStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuditStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SalesArchivesType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SalesArchivesType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SalesArchivesType.class.getSimpleName());
            }
        }
        if(clazz.equals(SceneCode.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SceneCode.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SceneCode.class.getSimpleName());
            }
        }
        if(clazz.equals(RuleType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RuleType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RuleType.class.getSimpleName());
            }
        }
        if(clazz.equals(ConfigItemValueType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ConfigItemValueType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ConfigItemValueType.class.getSimpleName());
            }
        }
        if(clazz.equals(ActiveStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ActiveStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ActiveStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ConversionStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ConversionStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ConversionStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(StroreInfo.class)) {
            isValid = vals.stream()
                    .filter(val -> null != StroreInfo.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, StroreInfo.class.getSimpleName());
            }
        }
        if(clazz.equals(SalesArchivesStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SalesArchivesStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SalesArchivesStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ActiveStatusXcfwPq8gAr8odnqVdgJyja.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ActiveStatusXcfwPq8gAr8odnqVdgJyja.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ActiveStatusXcfwPq8gAr8odnqVdgJyja.class.getSimpleName());
            }
        }
        if(clazz.equals(ConversionStatusQUPLNo8Y3eeH99vE6So4NJ.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ConversionStatusQUPLNo8Y3eeH99vE6So4NJ.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ConversionStatusQUPLNo8Y3eeH99vE6So4NJ.class.getSimpleName());
            }
        }
        if(clazz.equals(ChangeType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChangeType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChangeType.class.getSimpleName());
            }
        }
        if(clazz.equals(ChangeTableType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChangeTableType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChangeTableType.class.getSimpleName());
            }
        }
        if(clazz.equals(RetailerTenantCode.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RetailerTenantCode.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RetailerTenantCode.class.getSimpleName());
            }
        }
        if(clazz.equals(FromFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FromFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FromFlag.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
