package com.xforceplus.ultraman.app.casservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * rule_type
 * </p>
 *
 * @author ultraman
 * @since 2024-01-06
 */
public enum RuleType {

    _1("1", "零售商品牌商业务映射业务规则");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RuleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RuleType fromCode(String code) {
        return Stream.of(RuleType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
