package com.xforceplus.ultraman.app.casservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * scene_code
 * </p>
 *
 * @author ultraman
 * @since 2024-01-06
 */
public enum SceneCode {

    _0("0", "全部");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SceneCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SceneCode fromCode(String code) {
        return Stream.of(SceneCode.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
