package com.xforceplus.ultraman.app.casservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * strore_info
 * </p>
 *
 * @author ultraman
 * @since 2024-01-06
 */
public enum StroreInfo {

    RTMART("rtmart", "rtmart(大润发)");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    StroreInfo(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static StroreInfo fromCode(String code) {
        return Stream.of(StroreInfo.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
