package com.xforceplus.ultraman.app.casservice.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * sales_archives
 * </p>
 *
 * @author ultraman
 * @since 2024-01-06
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SalesArchives implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 客户 ID
   */
  private String customerId;
  /**
   * 客户编号
   */
  private String customerNo;
  /**
   * 销售组织代码
   */
  private String salesOrgnizationCode;
  /**
   * 销售组织名称
   */
  private String salesOrgnizationName;
  /**
   * 所属产品组代码
   */
  private String productGroupCode;
  /**
   * 所属产品组名称
   */
  private String productGroupName;
  /**
   * 所属分销渠道代码
   */
  private String channelCode;
  /**
   * 所属分销渠道名称
   */
  private String channelName;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 售达方编码
   */
  private String soldToPartyCode;
  /**
   * 售达方名称
   */
  private String soldToPartyName;
  /**
   * 送达方编码
   */
  private String shipToPartyCode;
  /**
   * 送达方名称
   */
  private String shipToPartyName;
  /**
   * 收票方编码
   */
  private String billToPartyCode;
  /**
   * 收票方名称
   */
  private String billToPartyName;
  /**
   * 付款方编码
   */
  private String payerCode;
  /**
   * 付款方名称
   */
  private String payerName;
  /**
   * 销售档案类型
   */
  private String salesArchivesType;
  /**
   * 系统来源
   */
  private String source;
  /**
   * 客户名称
   */
  private String customerName;
  /**
   * 账套名称
   */
  private String accountSetName;
  /**
   * 账套编码
   */
  private String accountSetCode;
  /**
   * 联系人电话
   */
  private String purchasePhone;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("customerId", customerId);
      map.put("customerNo", customerNo);
      map.put("salesOrgnizationCode", salesOrgnizationCode);
      map.put("salesOrgnizationName", salesOrgnizationName);
      map.put("productGroupCode", productGroupCode);
      map.put("productGroupName", productGroupName);
      map.put("channelCode", channelCode);
      map.put("channelName", channelName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("soldToPartyCode", soldToPartyCode);
      map.put("soldToPartyName", soldToPartyName);
      map.put("shipToPartyCode", shipToPartyCode);
      map.put("shipToPartyName", shipToPartyName);
      map.put("billToPartyCode", billToPartyCode);
      map.put("billToPartyName", billToPartyName);
      map.put("payerCode", payerCode);
      map.put("payerName", payerName);
      map.put("salesArchivesType", salesArchivesType);
      map.put("source", source);
      map.put("customerName", customerName);
      map.put("accountSetName", accountSetName);
      map.put("accountSetCode", accountSetCode);
      map.put("purchasePhone", purchasePhone);

      return map;
  }

  public static SalesArchives fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    SalesArchives entity = new SalesArchives();

    if(map.containsKey("customerId")) {
      Object obj = map.get("customerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerNo")) {
      Object obj = map.get("customerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrgnizationCode")) {
      Object obj = map.get("salesOrgnizationCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesOrgnizationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrgnizationName")) {
      Object obj = map.get("salesOrgnizationName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesOrgnizationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productGroupCode")) {
      Object obj = map.get("productGroupCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productGroupName")) {
      Object obj = map.get("productGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("channelCode")) {
      Object obj = map.get("channelCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChannelCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("channelName")) {
      Object obj = map.get("channelName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChannelName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("soldToPartyCode")) {
      Object obj = map.get("soldToPartyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSoldToPartyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("soldToPartyName")) {
      Object obj = map.get("soldToPartyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSoldToPartyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipToPartyCode")) {
      Object obj = map.get("shipToPartyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShipToPartyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipToPartyName")) {
      Object obj = map.get("shipToPartyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShipToPartyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billToPartyCode")) {
      Object obj = map.get("billToPartyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillToPartyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billToPartyName")) {
      Object obj = map.get("billToPartyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillToPartyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payerCode")) {
      Object obj = map.get("payerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payerName")) {
      Object obj = map.get("payerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesArchivesType")) {
      Object obj = map.get("salesArchivesType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesArchivesType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerName")) {
      Object obj = map.get("customerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountSetName")) {
      Object obj = map.get("accountSetName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountSetName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountSetCode")) {
      Object obj = map.get("accountSetCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountSetCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasePhone")) {
      Object obj = map.get("purchasePhone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchasePhone((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("customerId")) {
      Object obj = map.get("customerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCustomerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerNo")) {
      Object obj = map.get("customerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCustomerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrgnizationCode")) {
      Object obj = map.get("salesOrgnizationCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesOrgnizationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrgnizationName")) {
      Object obj = map.get("salesOrgnizationName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesOrgnizationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productGroupCode")) {
      Object obj = map.get("productGroupCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProductGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productGroupName")) {
      Object obj = map.get("productGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProductGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("channelCode")) {
      Object obj = map.get("channelCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setChannelCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("channelName")) {
      Object obj = map.get("channelName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setChannelName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("soldToPartyCode")) {
      Object obj = map.get("soldToPartyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSoldToPartyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("soldToPartyName")) {
      Object obj = map.get("soldToPartyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSoldToPartyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipToPartyCode")) {
      Object obj = map.get("shipToPartyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setShipToPartyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipToPartyName")) {
      Object obj = map.get("shipToPartyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setShipToPartyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billToPartyCode")) {
      Object obj = map.get("billToPartyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillToPartyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billToPartyName")) {
      Object obj = map.get("billToPartyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillToPartyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payerCode")) {
      Object obj = map.get("payerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPayerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payerName")) {
      Object obj = map.get("payerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPayerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesArchivesType")) {
      Object obj = map.get("salesArchivesType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesArchivesType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerName")) {
      Object obj = map.get("customerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountSetName")) {
      Object obj = map.get("accountSetName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAccountSetName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountSetCode")) {
      Object obj = map.get("accountSetCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAccountSetCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchasePhone")) {
      Object obj = map.get("purchasePhone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchasePhone((String)obj);
        }
      } else{
      }
    }
  }
}
