package com.xforceplus.ultraman.app.casservice.metadata.meta;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.xforceplus.ultraman.bocp.gen.typed.TypedField;

/**
* 对象元数据
*
* @author ultraman
* @since 2024-01-06
*/
public class EntityMeta {
    public interface OqsengineSdkOmAuditLog {
        static Long id() {
            return 1732317712071864322L;
        }
        static String code() {
            return "oqsengineSdkOmAuditLog";
        }
        TypedField<Long> OPERATOR_ID = new TypedField<>(Long.class, "operator_id");
        TypedField<String> OPERATOR_CODE = new TypedField<>(String.class, "operator_code");
        TypedField<String> OPERATOR_NAME = new TypedField<>(String.class, "operator_name");
        TypedField<String> OPERATE_TYPE = new TypedField<>(String.class, "operate_type");
        TypedField<LocalDateTime> OPERATE_TIME = new TypedField<>(LocalDateTime.class, "operate_time");
        TypedField<Long> APP_ID = new TypedField<>(Long.class, "app_id");
        TypedField<String> APP_CODE = new TypedField<>(String.class, "app_code");
        TypedField<Long> BO_ID = new TypedField<>(Long.class, "bo_id");
        TypedField<String> BO_CODE = new TypedField<>(String.class, "bo_code");
        TypedField<String> BO_NAME = new TypedField<>(String.class, "bo_name");
        TypedField<Long> ENTITY_ID = new TypedField<>(Long.class, "entity_id");
        TypedField<String> ORIGIN_DATA = new TypedField<>(String.class, "origin_data");
        TypedField<String> REQUEST_DATA = new TypedField<>(String.class, "request_data");
        TypedField<String> RESPONSE_DATA = new TypedField<>(String.class, "response_data");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface UltramanSysBoUserSetting {
        static Long id() {
            return 1732317714328399874L;
        }
        static String code() {
            return "ultramanSysBoUserSetting";
        }
        TypedField<String> CONFIG = new TypedField<>(String.class, "config");
        TypedField<String> STORE_KEY = new TypedField<>(String.class, "store_key");
        TypedField<String> EXTRA = new TypedField<>(String.class, "extra");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface FlowInstanceLog {
        static Long id() {
            return 1732317715725103106L;
        }
        static String code() {
            return "flowInstanceLog";
        }
        TypedField<String> INSTANCE_ID = new TypedField<>(String.class, "instanceId");
        TypedField<String> FLOW_CODE = new TypedField<>(String.class, "flowCode");
        TypedField<String> ERROR_MSG = new TypedField<>(String.class, "errorMsg");
        TypedField<String> EXCEPTION_TRACE = new TypedField<>(String.class, "exceptionTrace");
        TypedField<String> ERROR_NODE_ID = new TypedField<>(String.class, "errorNodeId");
        TypedField<Boolean> ROLLBACK = new TypedField<>(Boolean.class, "rollback");
        TypedField<String> SNAPSHOT = new TypedField<>(String.class, "snapshot");
        TypedField<String> SNAPSHOT_FORMAT = new TypedField<>(String.class, "snapshotFormat");
        TypedField<String> ROLLBACK_NODE_ID = new TypedField<>(String.class, "rollbackNodeId");
        TypedField<String> FLOW_NAME = new TypedField<>(String.class, "flowName");
        TypedField<String> NODE_HISTORY = new TypedField<>(String.class, "nodeHistory");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> START_SNAPSHOT = new TypedField<>(String.class, "startSnapshot");
        TypedField<String> START_SNAPSHOT_FORMAT = new TypedField<>(String.class, "startSnapshotFormat");
        TypedField<String> COMPLETE_SNAPSHOT = new TypedField<>(String.class, "completeSnapshot");
        TypedField<String> COMPLETE_SNAPSHOT_FORMAT = new TypedField<>(String.class, "completeSnapshotFormat");
        TypedField<String> EXTEND_LOG = new TypedField<>(String.class, "extendLog");
        TypedField<String> PARENT_INSTANCE_ID = new TypedField<>(String.class, "parentInstanceId");
        TypedField<String> PARENT_NODE_ID = new TypedField<>(String.class, "parentNodeId");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface FlowReplayLog {
        static Long id() {
            return 1732317718308794369L;
        }
        static String code() {
            return "flowReplayLog";
        }
        TypedField<String> FLOW_INSTANCE_ID = new TypedField<>(String.class, "flowInstanceId");
        TypedField<String> FLOW_CODE = new TypedField<>(String.class, "flowCode");
        TypedField<String> ERROR_MSG = new TypedField<>(String.class, "errorMsg");
        TypedField<String> EXCEPTION_TRACE = new TypedField<>(String.class, "exceptionTrace");
        TypedField<String> ERROR_NODE_ID = new TypedField<>(String.class, "errorNodeId");
        TypedField<Boolean> ROLLBACK = new TypedField<>(Boolean.class, "rollback");
        TypedField<String> ROLLBACK_NODE_ID = new TypedField<>(String.class, "rollbackNodeId");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface CustomerChannelRelation {
        static Long id() {
            return 1732329334625112065L;
        }
        static String code() {
            return "customerChannelRelation";
        }
        TypedField<String> CUSTOMER_ID = new TypedField<>(String.class, "customerId");
        TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "customerNo");
        TypedField<String> CHANNEL_CODE = new TypedField<>(String.class, "channelCode");
        TypedField<String> CHANNEL_NAME = new TypedField<>(String.class, "channelName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface CustomerProductGroupRelation {
        static Long id() {
            return 1732329666462662657L;
        }
        static String code() {
            return "customerProductGroupRelation";
        }
        TypedField<String> CUSTOMER_ID = new TypedField<>(String.class, "customerId");
        TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "customerNo");
        TypedField<String> PRODUCT_GROUP_CODE = new TypedField<>(String.class, "productGroupCode");
        TypedField<String> PRODUCT_GROUP_NAME = new TypedField<>(String.class, "productGroupName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface CustomerSaleOrganization {
        static Long id() {
            return 1732330059448528898L;
        }
        static String code() {
            return "customerSaleOrganization";
        }
        TypedField<String> CUSTOMER_ID = new TypedField<>(String.class, "customerId");
        TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "customerNo");
        TypedField<String> SALE_ORGANIZATION_CODE = new TypedField<>(String.class, "saleOrganizationCode");
        TypedField<String> SALE_ORGANIZATION_NAME = new TypedField<>(String.class, "saleOrganizationName");
        TypedField<String> COMPANY_CODE = new TypedField<>(String.class, "companyCode");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface SalesArchives {
        static Long id() {
            return 1732340433345888258L;
        }
        static String code() {
            return "salesArchives";
        }
        TypedField<String> CUSTOMER_ID = new TypedField<>(String.class, "customerId");
        TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "customerNo");
        TypedField<String> SALES_ORGNIZATION_CODE = new TypedField<>(String.class, "salesOrgnizationCode");
        TypedField<String> SALES_ORGNIZATION_NAME = new TypedField<>(String.class, "salesOrgnizationName");
        TypedField<String> PRODUCT_GROUP_CODE = new TypedField<>(String.class, "productGroupCode");
        TypedField<String> PRODUCT_GROUP_NAME = new TypedField<>(String.class, "productGroupName");
        TypedField<String> CHANNEL_CODE = new TypedField<>(String.class, "channelCode");
        TypedField<String> CHANNEL_NAME = new TypedField<>(String.class, "channelName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SOLD_TO_PARTY_CODE = new TypedField<>(String.class, "soldToPartyCode");
        TypedField<String> SOLD_TO_PARTY_NAME = new TypedField<>(String.class, "soldToPartyName");
        TypedField<String> SHIP_TO_PARTY_CODE = new TypedField<>(String.class, "shipToPartyCode");
        TypedField<String> SHIP_TO_PARTY_NAME = new TypedField<>(String.class, "shipToPartyName");
        TypedField<String> BILL_TO_PARTY_CODE = new TypedField<>(String.class, "billToPartyCode");
        TypedField<String> BILL_TO_PARTY_NAME = new TypedField<>(String.class, "billToPartyName");
        TypedField<String> PAYER_CODE = new TypedField<>(String.class, "payerCode");
        TypedField<String> PAYER_NAME = new TypedField<>(String.class, "payerName");
        TypedField<String> SALES_ARCHIVES_TYPE = new TypedField<>(String.class, "salesArchivesType");
        TypedField<String> SOURCE = new TypedField<>(String.class, "source");
        TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "customerName");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
        /**
         * 租户定制对象
         */
        interface Tenant {
            interface TQLS {
                TypedField<String> ACCOUNT_SET_NAME = new TypedField<>(String.class, "accountSetName");
                TypedField<String> ACCOUNT_SET_CODE = new TypedField<>(String.class, "accountSetCode");
            }
            interface QZDREAM {
                TypedField<String> PURCHASE_PHONE = new TypedField<>(String.class, "purchasePhone");
            }
        }
    }
    public interface SalesOrgnizationAffiliateInfo {
        static Long id() {
            return 1732635899630555137L;
        }
        static String code() {
            return "salesOrgnizationAffiliateInfo";
        }
        TypedField<String> SALES_ORGNIZATION_CODE = new TypedField<>(String.class, "salesOrgnizationCode");
        TypedField<String> SALES_ORGNIZATION_NAME = new TypedField<>(String.class, "salesOrgnizationName");
        TypedField<String> PRODUCT_GROUP_CODE = new TypedField<>(String.class, "productGroupCode");
        TypedField<String> PRODUCT_GROUP_NAME = new TypedField<>(String.class, "productGroupName");
        TypedField<String> VOUCHER_TYPE = new TypedField<>(String.class, "voucherType");
        TypedField<String> VOUCHER_CURRENCY = new TypedField<>(String.class, "voucherCurrency");
        TypedField<String> SHIPMENT_TYPE = new TypedField<>(String.class, "shipmentType");
        TypedField<String> TRANSPORTATION_MODE_TYPE = new TypedField<>(String.class, "transportationModeType");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> RETURN_VOUCHER_TYPE = new TypedField<>(String.class, "returnVoucherType");
    }
    public interface RetailerSupplierMapping {
        static Long id() {
            return 1732638206927122433L;
        }
        static String code() {
            return "retailerSupplierMapping";
        }
        TypedField<String> RETAILER_CODE = new TypedField<>(String.class, "retailerCode");
        TypedField<String> RETAILER_NAME = new TypedField<>(String.class, "retailerName");
        TypedField<String> STORE_CODE = new TypedField<>(String.class, "storeCode");
        TypedField<String> STORE_NAME = new TypedField<>(String.class, "storeName");
        TypedField<String> SUPPLIER_CODE = new TypedField<>(String.class, "supplierCode");
        TypedField<String> SUPPLIER_NAME = new TypedField<>(String.class, "supplierName");
        TypedField<String> SHIPPED_BY = new TypedField<>(String.class, "shippedBy");
        TypedField<String> WAREHOUSE_CODE = new TypedField<>(String.class, "warehouseCode");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "auditStatus");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> WAREHOUSE_NAME = new TypedField<>(String.class, "warehouseName");
        TypedField<String> SCENE_CODE = new TypedField<>(String.class, "sceneCode");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        /**
         * 对一关联关系 关联对象 salesArchives
         */
        TypedField<Long> ONEONE_FOR_SALES_ARCHIVES_ID = new TypedField<>(Long.class, "oneoneForSalesArchives.id");
        /**
         * 对一关联关系 关联对象 storeInfo
         */
        TypedField<Long> STORE_REL_ID = new TypedField<>(Long.class, "storeRel.id");
        /**
         * 对一关联关系 关联对象 purchaseOrgs
         */
        TypedField<Long> SHOP_REL_ID = new TypedField<>(Long.class, "shopRel.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface ONEONE_FOR_SALES_ARCHIVES {
                static String code () {
                    return "oneoneForSalesArchives" ;
                }
                TypedField<String> CUSTOMER_ID = new TypedField<>(String.class, "oneoneForSalesArchives.customerId");
                TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "oneoneForSalesArchives.customerNo");
                TypedField<String> SALES_ORGNIZATION_CODE = new TypedField<>(String.class, "oneoneForSalesArchives.salesOrgnizationCode");
                TypedField<String> SALES_ORGNIZATION_NAME = new TypedField<>(String.class, "oneoneForSalesArchives.salesOrgnizationName");
                TypedField<String> PRODUCT_GROUP_CODE = new TypedField<>(String.class, "oneoneForSalesArchives.productGroupCode");
                TypedField<String> PRODUCT_GROUP_NAME = new TypedField<>(String.class, "oneoneForSalesArchives.productGroupName");
                TypedField<String> CHANNEL_CODE = new TypedField<>(String.class, "oneoneForSalesArchives.channelCode");
                TypedField<String> CHANNEL_NAME = new TypedField<>(String.class, "oneoneForSalesArchives.channelName");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneoneForSalesArchives.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneoneForSalesArchives.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneoneForSalesArchives.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneoneForSalesArchives.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneoneForSalesArchives.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneoneForSalesArchives.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneoneForSalesArchives.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneoneForSalesArchives.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneoneForSalesArchives.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneoneForSalesArchives.delete_flag");
                TypedField<String> SOLD_TO_PARTY_CODE = new TypedField<>(String.class, "oneoneForSalesArchives.soldToPartyCode");
                TypedField<String> SOLD_TO_PARTY_NAME = new TypedField<>(String.class, "oneoneForSalesArchives.soldToPartyName");
                TypedField<String> SHIP_TO_PARTY_CODE = new TypedField<>(String.class, "oneoneForSalesArchives.shipToPartyCode");
                TypedField<String> SHIP_TO_PARTY_NAME = new TypedField<>(String.class, "oneoneForSalesArchives.shipToPartyName");
                TypedField<String> BILL_TO_PARTY_CODE = new TypedField<>(String.class, "oneoneForSalesArchives.billToPartyCode");
                TypedField<String> BILL_TO_PARTY_NAME = new TypedField<>(String.class, "oneoneForSalesArchives.billToPartyName");
                TypedField<String> PAYER_CODE = new TypedField<>(String.class, "oneoneForSalesArchives.payerCode");
                TypedField<String> PAYER_NAME = new TypedField<>(String.class, "oneoneForSalesArchives.payerName");
                TypedField<String> SALES_ARCHIVES_TYPE = new TypedField<>(String.class, "oneoneForSalesArchives.salesArchivesType");
                TypedField<String> SOURCE = new TypedField<>(String.class, "oneoneForSalesArchives.source");
                TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "oneoneForSalesArchives.customerName");
            }
            interface STORE_REL {
                static String code () {
                    return "storeRel" ;
                }
                TypedField<String> CODE = new TypedField<>(String.class, "storeRel.code");
                TypedField<String> NAME = new TypedField<>(String.class, "storeRel.name");
                TypedField<Long> ID = new TypedField<>(Long.class, "storeRel.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "storeRel.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "storeRel.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "storeRel.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "storeRel.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "storeRel.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "storeRel.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "storeRel.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "storeRel.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "storeRel.delete_flag");
            }
            interface SHOP_REL {
                static String code () {
                    return "shopRel" ;
                }
                TypedField<String> PURCHASE_RETAILER_ID = new TypedField<>(String.class, "shopRel.purchaseRetailerId");
                TypedField<String> PURCHASE_RETAILER_NAME = new TypedField<>(String.class, "shopRel.purchaseRetailerName");
                TypedField<String> S_SALES_ORGANIZATION_CODE = new TypedField<>(String.class, "shopRel.sSalesOrganizationCode");
                TypedField<String> S_SALES_ORGANIZATION_NAME = new TypedField<>(String.class, "shopRel.sSalesOrganizationName");
                TypedField<String> PURCHASE_STORE_CODE = new TypedField<>(String.class, "shopRel.purchaseStoreCode");
                TypedField<String> PURCHASE_STORE_NAME = new TypedField<>(String.class, "shopRel.purchaseStoreName");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "shopRel.sellerCode");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "shopRel.sellerName");
                TypedField<String> ACTIVE_STATUS = new TypedField<>(String.class, "shopRel.activeStatus");
                TypedField<String> CONVERSION_STATUS = new TypedField<>(String.class, "shopRel.conversionStatus");
                TypedField<Long> ID = new TypedField<>(Long.class, "shopRel.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "shopRel.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "shopRel.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "shopRel.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "shopRel.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "shopRel.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "shopRel.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "shopRel.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "shopRel.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "shopRel.delete_flag");
            }
        }
        /**
         * 租户定制对象
         */
        interface Tenant {
            interface TQLS {
            }
            interface QZDREAM {
            }
        }
    }
    public interface SalesArchivesChangedHistory {
        static Long id() {
            return 1733004784053620737L;
        }
        static String code() {
            return "salesArchivesChangedHistory";
        }
        TypedField<String> OPERATION_USER = new TypedField<>(String.class, "operationUser");
        TypedField<LocalDateTime> OPERATION_TIME = new TypedField<>(LocalDateTime.class, "operationTime");
        TypedField<String> OPERATION_CONTENT = new TypedField<>(String.class, "operationContent");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联关系 关联对象 salesArchives
         */
        TypedField<Long> ONE_TO_MANY_FOR_CHANGED_HISTORY_ID = new TypedField<>(Long.class, "oneToManyForChangedHistory.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface ONE_TO_MANY_FOR_CHANGED_HISTORY {
                static String code () {
                    return "oneToManyForChangedHistory" ;
                }
                TypedField<String> CUSTOMER_ID = new TypedField<>(String.class, "oneToManyForChangedHistory.customerId");
                TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "oneToManyForChangedHistory.customerNo");
                TypedField<String> SALES_ORGNIZATION_CODE = new TypedField<>(String.class, "oneToManyForChangedHistory.salesOrgnizationCode");
                TypedField<String> SALES_ORGNIZATION_NAME = new TypedField<>(String.class, "oneToManyForChangedHistory.salesOrgnizationName");
                TypedField<String> PRODUCT_GROUP_CODE = new TypedField<>(String.class, "oneToManyForChangedHistory.productGroupCode");
                TypedField<String> PRODUCT_GROUP_NAME = new TypedField<>(String.class, "oneToManyForChangedHistory.productGroupName");
                TypedField<String> CHANNEL_CODE = new TypedField<>(String.class, "oneToManyForChangedHistory.channelCode");
                TypedField<String> CHANNEL_NAME = new TypedField<>(String.class, "oneToManyForChangedHistory.channelName");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneToManyForChangedHistory.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneToManyForChangedHistory.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneToManyForChangedHistory.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneToManyForChangedHistory.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneToManyForChangedHistory.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneToManyForChangedHistory.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneToManyForChangedHistory.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneToManyForChangedHistory.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneToManyForChangedHistory.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneToManyForChangedHistory.delete_flag");
                TypedField<String> SOLD_TO_PARTY_CODE = new TypedField<>(String.class, "oneToManyForChangedHistory.soldToPartyCode");
                TypedField<String> SOLD_TO_PARTY_NAME = new TypedField<>(String.class, "oneToManyForChangedHistory.soldToPartyName");
                TypedField<String> SHIP_TO_PARTY_CODE = new TypedField<>(String.class, "oneToManyForChangedHistory.shipToPartyCode");
                TypedField<String> SHIP_TO_PARTY_NAME = new TypedField<>(String.class, "oneToManyForChangedHistory.shipToPartyName");
                TypedField<String> BILL_TO_PARTY_CODE = new TypedField<>(String.class, "oneToManyForChangedHistory.billToPartyCode");
                TypedField<String> BILL_TO_PARTY_NAME = new TypedField<>(String.class, "oneToManyForChangedHistory.billToPartyName");
                TypedField<String> PAYER_CODE = new TypedField<>(String.class, "oneToManyForChangedHistory.payerCode");
                TypedField<String> PAYER_NAME = new TypedField<>(String.class, "oneToManyForChangedHistory.payerName");
                TypedField<String> SALES_ARCHIVES_TYPE = new TypedField<>(String.class, "oneToManyForChangedHistory.salesArchivesType");
                TypedField<String> SOURCE = new TypedField<>(String.class, "oneToManyForChangedHistory.source");
                TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "oneToManyForChangedHistory.customerName");
            }
        }
    }
    public interface SalesArchivesForConfig {
        static Long id() {
            return 1734474521750614017L;
        }
        static String code() {
            return "salesArchivesForConfig";
        }
        TypedField<String> CUSTOMER_ID = new TypedField<>(String.class, "customerId");
        TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "customerNo");
        TypedField<String> SALES_ORGNIZATION_CODE = new TypedField<>(String.class, "salesOrgnizationCode");
        TypedField<String> SALES_ORGNIZATION_NAME = new TypedField<>(String.class, "salesOrgnizationName");
        TypedField<String> PRODUCT_GROUP_CODE = new TypedField<>(String.class, "productGroupCode");
        TypedField<String> PRODUCT_GROUP_NAME = new TypedField<>(String.class, "productGroupName");
        TypedField<String> CHANNEL_CODE = new TypedField<>(String.class, "channelCode");
        TypedField<String> CHANNEL_NAME = new TypedField<>(String.class, "channelName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SOLD_TO_PARTY_CODE = new TypedField<>(String.class, "soldToPartyCode");
        TypedField<String> SOLD_TO_PARTY_NAME = new TypedField<>(String.class, "soldToPartyName");
        TypedField<String> SHIP_TO_PARTY_CODE = new TypedField<>(String.class, "shipToPartyCode");
        TypedField<String> SHIP_TO_PARTY_NAME = new TypedField<>(String.class, "shipToPartyName");
        TypedField<String> BILL_TO_PARTY_CODE = new TypedField<>(String.class, "billToPartyCode");
        TypedField<String> BILL_TO_PARTY_NAME = new TypedField<>(String.class, "billToPartyName");
        TypedField<String> PAYER_CODE = new TypedField<>(String.class, "payerCode");
        TypedField<String> PAYER_NAME = new TypedField<>(String.class, "payerName");
        TypedField<String> SALES_ARCHIVES_TYPE = new TypedField<>(String.class, "salesArchivesType");
        TypedField<String> SOURCE = new TypedField<>(String.class, "source");
        TypedField<String> CUSTOMER_NAME = new TypedField<>(String.class, "customerName");
        /**
         * 对一关联关系 关联对象 retailerSupplierMapping
         */
        TypedField<Long> ONEMANY_FOR_SALES_ARCHIVES_ID = new TypedField<>(Long.class, "onemanyForSalesArchives.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface ONEMANY_FOR_SALES_ARCHIVES {
                static String code () {
                    return "onemanyForSalesArchives" ;
                }
                TypedField<String> RETAILER_CODE = new TypedField<>(String.class, "onemanyForSalesArchives.retailerCode");
                TypedField<String> RETAILER_NAME = new TypedField<>(String.class, "onemanyForSalesArchives.retailerName");
                TypedField<String> STORE_CODE = new TypedField<>(String.class, "onemanyForSalesArchives.storeCode");
                TypedField<String> STORE_NAME = new TypedField<>(String.class, "onemanyForSalesArchives.storeName");
                TypedField<String> SUPPLIER_CODE = new TypedField<>(String.class, "onemanyForSalesArchives.supplierCode");
                TypedField<String> SUPPLIER_NAME = new TypedField<>(String.class, "onemanyForSalesArchives.supplierName");
                TypedField<String> SHIPPED_BY = new TypedField<>(String.class, "onemanyForSalesArchives.shippedBy");
                TypedField<String> WAREHOUSE_CODE = new TypedField<>(String.class, "onemanyForSalesArchives.warehouseCode");
                TypedField<String> STATUS = new TypedField<>(String.class, "onemanyForSalesArchives.status");
                TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "onemanyForSalesArchives.auditStatus");
                TypedField<Long> ID = new TypedField<>(Long.class, "onemanyForSalesArchives.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "onemanyForSalesArchives.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "onemanyForSalesArchives.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "onemanyForSalesArchives.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "onemanyForSalesArchives.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "onemanyForSalesArchives.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "onemanyForSalesArchives.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "onemanyForSalesArchives.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "onemanyForSalesArchives.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "onemanyForSalesArchives.delete_flag");
                TypedField<String> WAREHOUSE_NAME = new TypedField<>(String.class, "onemanyForSalesArchives.warehouseName");
                TypedField<String> SCENE_CODE = new TypedField<>(String.class, "onemanyForSalesArchives.sceneCode");
                TypedField<String> EXT1 = new TypedField<>(String.class, "onemanyForSalesArchives.ext1");
            }
        }
    }
    public interface SceneCodeAndSalesArchivesTypeMapping {
        static Long id() {
            return 1735122732952162305L;
        }
        static String code() {
            return "sceneCodeAndSalesArchivesTypeMapping";
        }
        TypedField<String> SCENE_CODE = new TypedField<>(String.class, "sceneCode");
        TypedField<String> SALES_ARCHIVE_TYPE = new TypedField<>(String.class, "salesArchiveType");
        TypedField<String> NOTE = new TypedField<>(String.class, "note");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface ConfigRule {
        static Long id() {
            return 1737665625343397890L;
        }
        static String code() {
            return "configRule";
        }
        TypedField<String> RULE_TYPE = new TypedField<>(String.class, "ruleType");
        TypedField<String> SCENE_CODE = new TypedField<>(String.class, "sceneCode");
        TypedField<String> CONFIG_CONTENT = new TypedField<>(String.class, "configContent");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface ConfigRuleTemplate {
        static Long id() {
            return 1737667719927492609L;
        }
        static String code() {
            return "configRuleTemplate";
        }
        TypedField<String> CONFIG_RULE_TYPE = new TypedField<>(String.class, "configRuleType");
        TypedField<String> GROUP = new TypedField<>(String.class, "group");
        TypedField<String> CONFIG_ITEM_CODE = new TypedField<>(String.class, "configItemCode");
        TypedField<String> CONFIG_ITEM_NAME = new TypedField<>(String.class, "configItemName");
        TypedField<String> CONFIG_ITEM_VALUE_TYPE = new TypedField<>(String.class, "configItemValueType");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface StoreInfo {
        static Long id() {
            return 1743105666337853442L;
        }
        static String code() {
            return "storeInfo";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface PurchaseOrgs {
        static Long id() {
            return 1743187843868119042L;
        }
        static String code() {
            return "purchaseOrgs";
        }
        TypedField<String> PURCHASE_RETAILER_ID = new TypedField<>(String.class, "purchaseRetailerId");
        TypedField<String> PURCHASE_RETAILER_NAME = new TypedField<>(String.class, "purchaseRetailerName");
        TypedField<String> S_SALES_ORGANIZATION_CODE = new TypedField<>(String.class, "sSalesOrganizationCode");
        TypedField<String> S_SALES_ORGANIZATION_NAME = new TypedField<>(String.class, "sSalesOrganizationName");
        TypedField<String> PURCHASE_STORE_CODE = new TypedField<>(String.class, "purchaseStoreCode");
        TypedField<String> PURCHASE_STORE_NAME = new TypedField<>(String.class, "purchaseStoreName");
        TypedField<String> SELLER_CODE = new TypedField<>(String.class, "sellerCode");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> ACTIVE_STATUS = new TypedField<>(String.class, "activeStatus");
        TypedField<String> CONVERSION_STATUS = new TypedField<>(String.class, "conversionStatus");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
}
