package com.xforceplus.ultraman.app.casservice.metadata.validator;

import com.xforceplus.ultraman.app.casservice.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.casservice.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-01-06
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(FlowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FlowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SnapshotFormat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(RetailerSupplierMappingStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RetailerSupplierMappingStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RetailerSupplierMappingStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AuditStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuditStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuditStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SalesArchivesType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SalesArchivesType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SalesArchivesType.class.getSimpleName());
            }
        }
        if(clazz.equals(SceneCode.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SceneCode.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SceneCode.class.getSimpleName());
            }
        }
        if(clazz.equals(RuleType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RuleType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RuleType.class.getSimpleName());
            }
        }
        if(clazz.equals(ConfigItemValueType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ConfigItemValueType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ConfigItemValueType.class.getSimpleName());
            }
        }
        if(clazz.equals(ActiveStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ActiveStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ActiveStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ConversionStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ConversionStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ConversionStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(StroreInfo.class)) {
            isValid = vals.stream()
                    .filter(val -> null != StroreInfo.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, StroreInfo.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
