package com.xforceplus.ultraman.app.casservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.casservice.entity.CustomerChannelRelation;
import com.xforceplus.ultraman.app.casservice.service.ICustomerChannelRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-20
 */
@RestController
public class CustomerChannelRelationController {

  @Autowired
  private ICustomerChannelRelationService customerChannelRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param customerChannelRelation ${table.comment}
   * @return
   */
  @GetMapping("/customerchannelrelations" )
  public XfR getCustomerChannelRelations(XfPage page, CustomerChannelRelation customerChannelRelation) {
    return XfR.ok(customerChannelRelationServiceImpl.page(page, Wrappers.query(customerChannelRelation)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/customerchannelrelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(customerChannelRelationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param customerChannelRelation ${table.comment}
   * @return XfR
   */
  @PostMapping("/customerchannelrelations")
  public XfR save(@RequestBody CustomerChannelRelation customerChannelRelation) {
     return XfR.ok(customerChannelRelationServiceImpl.save(customerChannelRelation));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param customerChannelRelation ${table.comment}
   * @return XfR
   */
  @PutMapping("/customerchannelrelations/{id}")
  public XfR putUpdate(@RequestBody CustomerChannelRelation customerChannelRelation,@PathVariable Long id) {
      customerChannelRelation.setId(id);
      return XfR.ok(customerChannelRelationServiceImpl.updateById(customerChannelRelation));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param customerChannelRelation ${table.comment}
   * @return XfR
   */
  @PatchMapping("/customerchannelrelations/{id}")
  public XfR patchUpdate(@RequestBody CustomerChannelRelation customerChannelRelation,@PathVariable Long id) {
      CustomerChannelRelation upcustomerChannelRelation = customerChannelRelationServiceImpl.getById(id);
      if(upcustomerChannelRelation != null){
        upcustomerChannelRelation = ObjectCopyUtils.copyProperties(customerChannelRelation,upcustomerChannelRelation,true);
      }
      return XfR.ok(customerChannelRelationServiceImpl.updateById(upcustomerChannelRelation));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/customerchannelrelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(customerChannelRelationServiceImpl.removeById(id));
  }

  @PostMapping("/customerchannelrelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "customer_channel_relation");
     params.put("request", condition);

     return XfR.ok(customerChannelRelationServiceImpl.querys(params));
  }

}
