package com.xforceplus.ultraman.app.casservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.casservice.entity.RetailerSupplierMapping;
import com.xforceplus.ultraman.app.casservice.service.IRetailerSupplierMappingService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-20
 */
@RestController
public class RetailerSupplierMappingController {

  @Autowired
  private IRetailerSupplierMappingService retailerSupplierMappingServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param retailerSupplierMapping ${table.comment}
   * @return
   */
  @GetMapping("/retailersuppliermappings" )
  public XfR getRetailerSupplierMappings(XfPage page, RetailerSupplierMapping retailerSupplierMapping) {
    return XfR.ok(retailerSupplierMappingServiceImpl.page(page, Wrappers.query(retailerSupplierMapping)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/retailersuppliermappings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(retailerSupplierMappingServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param retailerSupplierMapping ${table.comment}
   * @return XfR
   */
  @PostMapping("/retailersuppliermappings")
  public XfR save(@RequestBody RetailerSupplierMapping retailerSupplierMapping) {
     return XfR.ok(retailerSupplierMappingServiceImpl.save(retailerSupplierMapping));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param retailerSupplierMapping ${table.comment}
   * @return XfR
   */
  @PutMapping("/retailersuppliermappings/{id}")
  public XfR putUpdate(@RequestBody RetailerSupplierMapping retailerSupplierMapping,@PathVariable Long id) {
      retailerSupplierMapping.setId(id);
      return XfR.ok(retailerSupplierMappingServiceImpl.updateById(retailerSupplierMapping));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param retailerSupplierMapping ${table.comment}
   * @return XfR
   */
  @PatchMapping("/retailersuppliermappings/{id}")
  public XfR patchUpdate(@RequestBody RetailerSupplierMapping retailerSupplierMapping,@PathVariable Long id) {
      RetailerSupplierMapping upretailerSupplierMapping = retailerSupplierMappingServiceImpl.getById(id);
      if(upretailerSupplierMapping != null){
        upretailerSupplierMapping = ObjectCopyUtils.copyProperties(retailerSupplierMapping,upretailerSupplierMapping,true);
      }
      return XfR.ok(retailerSupplierMappingServiceImpl.updateById(upretailerSupplierMapping));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/retailersuppliermappings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(retailerSupplierMappingServiceImpl.removeById(id));
  }

  @PostMapping("/retailersuppliermappings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "retailer_supplier_mapping");
     params.put("request", condition);

     return XfR.ok(retailerSupplierMappingServiceImpl.querys(params));
  }

}
