package com.xforceplus.ultraman.app.casservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.casservice.entity.SalesArchives;
import com.xforceplus.ultraman.app.casservice.service.ISalesArchivesService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-20
 */
@RestController
public class SalesArchivesController {

  @Autowired
  private ISalesArchivesService salesArchivesServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param salesArchives ${table.comment}
   * @return
   */
  @GetMapping("/salesarchivess" )
  public XfR getSalesArchivess(XfPage page, SalesArchives salesArchives) {
    return XfR.ok(salesArchivesServiceImpl.page(page, Wrappers.query(salesArchives)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/salesarchivess/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(salesArchivesServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param salesArchives ${table.comment}
   * @return XfR
   */
  @PostMapping("/salesarchivess")
  public XfR save(@RequestBody SalesArchives salesArchives) {
     return XfR.ok(salesArchivesServiceImpl.save(salesArchives));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param salesArchives ${table.comment}
   * @return XfR
   */
  @PutMapping("/salesarchivess/{id}")
  public XfR putUpdate(@RequestBody SalesArchives salesArchives,@PathVariable Long id) {
      salesArchives.setId(id);
      return XfR.ok(salesArchivesServiceImpl.updateById(salesArchives));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param salesArchives ${table.comment}
   * @return XfR
   */
  @PatchMapping("/salesarchivess/{id}")
  public XfR patchUpdate(@RequestBody SalesArchives salesArchives,@PathVariable Long id) {
      SalesArchives upsalesArchives = salesArchivesServiceImpl.getById(id);
      if(upsalesArchives != null){
        upsalesArchives = ObjectCopyUtils.copyProperties(salesArchives,upsalesArchives,true);
      }
      return XfR.ok(salesArchivesServiceImpl.updateById(upsalesArchives));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/salesarchivess/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(salesArchivesServiceImpl.removeById(id));
  }

  @PostMapping("/salesarchivess/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sales_archives");
     params.put("request", condition);

     return XfR.ok(salesArchivesServiceImpl.querys(params));
  }

}
