package com.xforceplus.ultraman.app.casservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.casservice.entity.SalesArchivesForConfig;
import com.xforceplus.ultraman.app.casservice.service.ISalesArchivesForConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-20
 */
@RestController
public class SalesArchivesForConfigController {

  @Autowired
  private ISalesArchivesForConfigService salesArchivesForConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param salesArchivesForConfig ${table.comment}
   * @return
   */
  @GetMapping("/salesarchivesforconfigs" )
  public XfR getSalesArchivesForConfigs(XfPage page, SalesArchivesForConfig salesArchivesForConfig) {
    return XfR.ok(salesArchivesForConfigServiceImpl.page(page, Wrappers.query(salesArchivesForConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/salesarchivesforconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(salesArchivesForConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param salesArchivesForConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/salesarchivesforconfigs")
  public XfR save(@RequestBody SalesArchivesForConfig salesArchivesForConfig) {
     return XfR.ok(salesArchivesForConfigServiceImpl.save(salesArchivesForConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param salesArchivesForConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/salesarchivesforconfigs/{id}")
  public XfR putUpdate(@RequestBody SalesArchivesForConfig salesArchivesForConfig,@PathVariable Long id) {
      salesArchivesForConfig.setId(id);
      return XfR.ok(salesArchivesForConfigServiceImpl.updateById(salesArchivesForConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param salesArchivesForConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/salesarchivesforconfigs/{id}")
  public XfR patchUpdate(@RequestBody SalesArchivesForConfig salesArchivesForConfig,@PathVariable Long id) {
      SalesArchivesForConfig upsalesArchivesForConfig = salesArchivesForConfigServiceImpl.getById(id);
      if(upsalesArchivesForConfig != null){
        upsalesArchivesForConfig = ObjectCopyUtils.copyProperties(salesArchivesForConfig,upsalesArchivesForConfig,true);
      }
      return XfR.ok(salesArchivesForConfigServiceImpl.updateById(upsalesArchivesForConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/salesarchivesforconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(salesArchivesForConfigServiceImpl.removeById(id));
  }

  @PostMapping("/salesarchivesforconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sales_archives_for_config");
     params.put("request", condition);

     return XfR.ok(salesArchivesForConfigServiceImpl.querys(params));
  }

}
