package com.xforceplus.ultraman.app.casservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.casservice.entity.SceneCodeAndSalesArchivesTypeMapping;
import com.xforceplus.ultraman.app.casservice.service.ISceneCodeAndSalesArchivesTypeMappingService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-20
 */
@RestController
public class SceneCodeAndSalesArchivesTypeMappingController {

  @Autowired
  private ISceneCodeAndSalesArchivesTypeMappingService sceneCodeAndSalesArchivesTypeMappingServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sceneCodeAndSalesArchivesTypeMapping ${table.comment}
   * @return
   */
  @GetMapping("/scenecodeandsalesarchivestypemappings" )
  public XfR getSceneCodeAndSalesArchivesTypeMappings(XfPage page, SceneCodeAndSalesArchivesTypeMapping sceneCodeAndSalesArchivesTypeMapping) {
    return XfR.ok(sceneCodeAndSalesArchivesTypeMappingServiceImpl.page(page, Wrappers.query(sceneCodeAndSalesArchivesTypeMapping)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/scenecodeandsalesarchivestypemappings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sceneCodeAndSalesArchivesTypeMappingServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param sceneCodeAndSalesArchivesTypeMapping ${table.comment}
   * @return XfR
   */
  @PostMapping("/scenecodeandsalesarchivestypemappings")
  public XfR save(@RequestBody SceneCodeAndSalesArchivesTypeMapping sceneCodeAndSalesArchivesTypeMapping) {
     return XfR.ok(sceneCodeAndSalesArchivesTypeMappingServiceImpl.save(sceneCodeAndSalesArchivesTypeMapping));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param sceneCodeAndSalesArchivesTypeMapping ${table.comment}
   * @return XfR
   */
  @PutMapping("/scenecodeandsalesarchivestypemappings/{id}")
  public XfR putUpdate(@RequestBody SceneCodeAndSalesArchivesTypeMapping sceneCodeAndSalesArchivesTypeMapping,@PathVariable Long id) {
      sceneCodeAndSalesArchivesTypeMapping.setId(id);
      return XfR.ok(sceneCodeAndSalesArchivesTypeMappingServiceImpl.updateById(sceneCodeAndSalesArchivesTypeMapping));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param sceneCodeAndSalesArchivesTypeMapping ${table.comment}
   * @return XfR
   */
  @PatchMapping("/scenecodeandsalesarchivestypemappings/{id}")
  public XfR patchUpdate(@RequestBody SceneCodeAndSalesArchivesTypeMapping sceneCodeAndSalesArchivesTypeMapping,@PathVariable Long id) {
      SceneCodeAndSalesArchivesTypeMapping upsceneCodeAndSalesArchivesTypeMapping = sceneCodeAndSalesArchivesTypeMappingServiceImpl.getById(id);
      if(upsceneCodeAndSalesArchivesTypeMapping != null){
        upsceneCodeAndSalesArchivesTypeMapping = ObjectCopyUtils.copyProperties(sceneCodeAndSalesArchivesTypeMapping,upsceneCodeAndSalesArchivesTypeMapping,true);
      }
      return XfR.ok(sceneCodeAndSalesArchivesTypeMappingServiceImpl.updateById(upsceneCodeAndSalesArchivesTypeMapping));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/scenecodeandsalesarchivestypemappings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sceneCodeAndSalesArchivesTypeMappingServiceImpl.removeById(id));
  }

  @PostMapping("/scenecodeandsalesarchivestypemappings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "scene_code_and_sales_archives_type_mapping");
     params.put("request", condition);

     return XfR.ok(sceneCodeAndSalesArchivesTypeMappingServiceImpl.querys(params));
  }

}
