package com.xforceplus.ultraman.app.casservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.casservice.entity.ConfigRuleTemplate;
import com.xforceplus.ultraman.app.casservice.service.IConfigRuleTemplateService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-04-19
 */
@RestController
public class ConfigRuleTemplateController {

  @Autowired
  private IConfigRuleTemplateService configRuleTemplateServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param configRuleTemplate ${table.comment}
   * @return
   */
  @GetMapping("/configruletemplates" )
  public XfR getConfigRuleTemplates(XfPage page, ConfigRuleTemplate configRuleTemplate) {
    return XfR.ok(configRuleTemplateServiceImpl.page(page, Wrappers.query(configRuleTemplate)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/configruletemplates/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(configRuleTemplateServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param configRuleTemplate ${table.comment}
   * @return XfR
   */
  @PostMapping("/configruletemplates")
  public XfR save(@RequestBody ConfigRuleTemplate configRuleTemplate) {
     return XfR.ok(configRuleTemplateServiceImpl.save(configRuleTemplate));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param configRuleTemplate ${table.comment}
   * @return XfR
   */
  @PutMapping("/configruletemplates/{id}")
  public XfR putUpdate(@RequestBody ConfigRuleTemplate configRuleTemplate,@PathVariable Long id) {
      configRuleTemplate.setId(id);
      return XfR.ok(configRuleTemplateServiceImpl.updateById(configRuleTemplate));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param configRuleTemplate ${table.comment}
   * @return XfR
   */
  @PatchMapping("/configruletemplates/{id}")
  public XfR patchUpdate(@RequestBody ConfigRuleTemplate configRuleTemplate,@PathVariable Long id) {
      ConfigRuleTemplate upconfigRuleTemplate = configRuleTemplateServiceImpl.getById(id);
      if(upconfigRuleTemplate != null){
        upconfigRuleTemplate = ObjectCopyUtils.copyProperties(configRuleTemplate,upconfigRuleTemplate,true);
      }
      return XfR.ok(configRuleTemplateServiceImpl.updateById(upconfigRuleTemplate));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/configruletemplates/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(configRuleTemplateServiceImpl.removeById(id));
  }

  @PostMapping("/configruletemplates/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "config_rule_template");
     params.put("request", condition);

     return XfR.ok(configRuleTemplateServiceImpl.querys(params));
  }

}
