package com.xforceplus.ultraman.app.casservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.casservice.entity.CustomerSaleOrganization;
import com.xforceplus.ultraman.app.casservice.service.ICustomerSaleOrganizationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-04-19
 */
@RestController
public class CustomerSaleOrganizationController {

  @Autowired
  private ICustomerSaleOrganizationService customerSaleOrganizationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param customerSaleOrganization ${table.comment}
   * @return
   */
  @GetMapping("/customersaleorganizations" )
  public XfR getCustomerSaleOrganizations(XfPage page, CustomerSaleOrganization customerSaleOrganization) {
    return XfR.ok(customerSaleOrganizationServiceImpl.page(page, Wrappers.query(customerSaleOrganization)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/customersaleorganizations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(customerSaleOrganizationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param customerSaleOrganization ${table.comment}
   * @return XfR
   */
  @PostMapping("/customersaleorganizations")
  public XfR save(@RequestBody CustomerSaleOrganization customerSaleOrganization) {
     return XfR.ok(customerSaleOrganizationServiceImpl.save(customerSaleOrganization));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param customerSaleOrganization ${table.comment}
   * @return XfR
   */
  @PutMapping("/customersaleorganizations/{id}")
  public XfR putUpdate(@RequestBody CustomerSaleOrganization customerSaleOrganization,@PathVariable Long id) {
      customerSaleOrganization.setId(id);
      return XfR.ok(customerSaleOrganizationServiceImpl.updateById(customerSaleOrganization));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param customerSaleOrganization ${table.comment}
   * @return XfR
   */
  @PatchMapping("/customersaleorganizations/{id}")
  public XfR patchUpdate(@RequestBody CustomerSaleOrganization customerSaleOrganization,@PathVariable Long id) {
      CustomerSaleOrganization upcustomerSaleOrganization = customerSaleOrganizationServiceImpl.getById(id);
      if(upcustomerSaleOrganization != null){
        upcustomerSaleOrganization = ObjectCopyUtils.copyProperties(customerSaleOrganization,upcustomerSaleOrganization,true);
      }
      return XfR.ok(customerSaleOrganizationServiceImpl.updateById(upcustomerSaleOrganization));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/customersaleorganizations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(customerSaleOrganizationServiceImpl.removeById(id));
  }

  @PostMapping("/customersaleorganizations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "customer_sale_organization");
     params.put("request", condition);

     return XfR.ok(customerSaleOrganizationServiceImpl.querys(params));
  }

}
