package com.xforceplus.ultraman.app.casservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.casservice.entity.OrgSoldShipToParty;
import com.xforceplus.ultraman.app.casservice.service.IOrgSoldShipToPartyService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-04-19
 */
@RestController
public class OrgSoldShipToPartyController {

  @Autowired
  private IOrgSoldShipToPartyService orgSoldShipToPartyServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orgSoldShipToParty ${table.comment}
   * @return
   */
  @GetMapping("/orgsoldshiptopartys" )
  public XfR getOrgSoldShipToPartys(XfPage page, OrgSoldShipToParty orgSoldShipToParty) {
    return XfR.ok(orgSoldShipToPartyServiceImpl.page(page, Wrappers.query(orgSoldShipToParty)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/orgsoldshiptopartys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orgSoldShipToPartyServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param orgSoldShipToParty ${table.comment}
   * @return XfR
   */
  @PostMapping("/orgsoldshiptopartys")
  public XfR save(@RequestBody OrgSoldShipToParty orgSoldShipToParty) {
     return XfR.ok(orgSoldShipToPartyServiceImpl.save(orgSoldShipToParty));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param orgSoldShipToParty ${table.comment}
   * @return XfR
   */
  @PutMapping("/orgsoldshiptopartys/{id}")
  public XfR putUpdate(@RequestBody OrgSoldShipToParty orgSoldShipToParty,@PathVariable Long id) {
      orgSoldShipToParty.setId(id);
      return XfR.ok(orgSoldShipToPartyServiceImpl.updateById(orgSoldShipToParty));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param orgSoldShipToParty ${table.comment}
   * @return XfR
   */
  @PatchMapping("/orgsoldshiptopartys/{id}")
  public XfR patchUpdate(@RequestBody OrgSoldShipToParty orgSoldShipToParty,@PathVariable Long id) {
      OrgSoldShipToParty uporgSoldShipToParty = orgSoldShipToPartyServiceImpl.getById(id);
      if(uporgSoldShipToParty != null){
        uporgSoldShipToParty = ObjectCopyUtils.copyProperties(orgSoldShipToParty,uporgSoldShipToParty,true);
      }
      return XfR.ok(orgSoldShipToPartyServiceImpl.updateById(uporgSoldShipToParty));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orgsoldshiptopartys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orgSoldShipToPartyServiceImpl.removeById(id));
  }

  @PostMapping("/orgsoldshiptopartys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "org_sold_ship_to_party");
     params.put("request", condition);

     return XfR.ok(orgSoldShipToPartyServiceImpl.querys(params));
  }

}
