package com.xforceplus.ultraman.app.casservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.casservice.entity.StoreInfo;
import com.xforceplus.ultraman.app.casservice.service.IStoreInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-05-07
 */
@RestController
public class StoreInfoController {

  @Autowired
  private IStoreInfoService storeInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param storeInfo ${table.comment}
   * @return
   */
  @GetMapping("/storeinfos" )
  public XfR getStoreInfos(XfPage page, StoreInfo storeInfo) {
    return XfR.ok(storeInfoServiceImpl.page(page, Wrappers.query(storeInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/storeinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(storeInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param storeInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/storeinfos")
  public XfR save(@RequestBody StoreInfo storeInfo) {
     return XfR.ok(storeInfoServiceImpl.save(storeInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param storeInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/storeinfos/{id}")
  public XfR putUpdate(@RequestBody StoreInfo storeInfo,@PathVariable Long id) {
      storeInfo.setId(id);
      return XfR.ok(storeInfoServiceImpl.updateById(storeInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param storeInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/storeinfos/{id}")
  public XfR patchUpdate(@RequestBody StoreInfo storeInfo,@PathVariable Long id) {
      StoreInfo upstoreInfo = storeInfoServiceImpl.getById(id);
      if(upstoreInfo != null){
        upstoreInfo = ObjectCopyUtils.copyProperties(storeInfo,upstoreInfo,true);
      }
      return XfR.ok(storeInfoServiceImpl.updateById(upstoreInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/storeinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(storeInfoServiceImpl.removeById(id));
  }

  @PostMapping("/storeinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "store_info");
     params.put("request", condition);

     return XfR.ok(storeInfoServiceImpl.querys(params));
  }

}
